/*
 * Decompiled with CFR 0.152.
 */
package org.progeeks.util;

import java.io.File;
import java.io.FileFilter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.progeeks.util.log.Log;

public class RegexFileFilter
extends javax.swing.filechooser.FileFilter
implements FileFilter {
    static Log log = Log.getLog();
    private String description;
    private Pattern pattern;
    private String basePath;

    public RegexFileFilter(String description, String regex) {
        this.description = description;
        this.pattern = Pattern.compile(regex);
    }

    public RegexFileFilter(String regex) {
        this("Files matching[" + regex + "]", regex);
    }

    public void setBasePath(File base) {
        this.basePath = base.getPath();
    }

    public boolean accept(File f) {
        String name;
        if (this.basePath != null) {
            name = f.getPath();
            if (name.startsWith(this.basePath)) {
                name = name.substring(this.basePath.length() + 1);
            }
            if (File.separatorChar == '\\') {
                name = name.replace(File.separatorChar, '/');
            }
        } else {
            name = f.getName();
        }
        if (f.isDirectory()) {
            name = name + "/";
        }
        if (log.isDebugEnabled()) {
            log.debug("Checking:" + name);
        }
        Matcher m = this.pattern.matcher(name);
        return m.matches();
    }

    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return "RegexFileFitler[" + this.description + ", " + this.pattern.pattern() + "]";
    }
}

