/*
 * Decompiled with CFR 0.152.
 */
package org.progeeks.util;

import java.util.AbstractList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReversedList<E>
extends AbstractList<E> {
    private List<E> delegate;

    public ReversedList() {
        this(null);
    }

    public ReversedList(List<E> delegate) {
        this.delegate = delegate;
    }

    protected List<E> getDelegate() {
        return this.delegate;
    }

    protected void setDelegate(List<E> delegate) {
        this.delegate = delegate;
    }

    protected final int toIndex(int index) {
        return this.delegate.size() - index - 1;
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }

    @Override
    public boolean contains(Object element) {
        return this.delegate.contains(element);
    }

    @Override
    public boolean containsAll(Collection collection) {
        return this.delegate.containsAll(collection);
    }

    @Override
    public boolean add(E element) {
        this.delegate.add(0, element);
        return true;
    }

    @Override
    public boolean remove(Object element) {
        ListIterator<E> i = this.delegate.listIterator(this.delegate.size());
        if (element == null) {
            while (i.hasPrevious()) {
                if (i.previous() != null) continue;
                i.remove();
                return true;
            }
        } else {
            while (i.hasPrevious()) {
                if (!element.equals(i.previous())) continue;
                i.remove();
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection collection) {
        return this.delegate.removeAll(collection);
    }

    @Override
    public boolean retainAll(Collection collection) {
        return this.delegate.retainAll(collection);
    }

    @Override
    public Iterator<E> iterator() {
        return new ReversedIterator(this.listIterator());
    }

    @Override
    public E get(int index) {
        return this.delegate.get(this.toIndex(index));
    }

    @Override
    public E set(int index, E element) {
        return this.delegate.set(this.toIndex(index), element);
    }

    @Override
    public int indexOf(Object element) {
        return this.toIndex(this.delegate.lastIndexOf(element));
    }

    @Override
    public int lastIndexOf(Object element) {
        return this.toIndex(this.delegate.indexOf(element));
    }

    @Override
    public void add(int index, E element) {
        this.delegate.add(this.toIndex(index) + 1, element);
    }

    @Override
    public E remove(int index) {
        return this.delegate.remove(this.toIndex(index));
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        return new ReversedList<E>(this.delegate.subList(this.toIndex(toIndex), this.toIndex(fromIndex)));
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        return new ReversedListIterator(this.delegate.listIterator(this.toIndex(index) + 1));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ReversedListIterator
    implements ListIterator<E> {
        private ListIterator<E> iter;

        ReversedListIterator(ListIterator<E> iter) {
            this.iter = iter;
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasPrevious();
        }

        @Override
        public boolean hasPrevious() {
            return this.iter.hasNext();
        }

        @Override
        public E next() {
            return this.iter.previous();
        }

        @Override
        public int nextIndex() {
            return ReversedList.this.toIndex(this.iter.previousIndex());
        }

        @Override
        public E previous() {
            return this.iter.next();
        }

        @Override
        public int previousIndex() {
            return ReversedList.this.toIndex(this.iter.nextIndex());
        }

        @Override
        public void add(E element) {
            this.iter.add(element);
            this.iter.previous();
        }

        @Override
        public void remove() {
            this.iter.remove();
        }

        @Override
        public void set(E element) {
            this.iter.set(element);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ReversedIterator<F>
    implements Iterator<F> {
        private Iterator<F> iter;

        ReversedIterator(Iterator<F> iter) {
            this.iter = iter;
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public F next() {
            return this.iter.next();
        }

        @Override
        public void remove() {
            this.iter.remove();
        }
    }
}

