/*
 * Decompiled with CFR 0.152.
 */
package org.progeeks.util;

import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class SafeDateFormat {
    private final String pattern;
    private final boolean lenient;
    private final TimeZone timeZone;
    private final ThreadLocal<DateFormat> parser;
    private final ThreadLocal<DateFormat> formatter;

    SafeDateFormat(String pattern, boolean lenient, TimeZone timeZone) {
        this.pattern = pattern;
        this.lenient = lenient;
        this.timeZone = (TimeZone)timeZone.clone();
        this.parser = new LocalFormat();
        this.formatter = new LocalFormat();
    }

    public static Builder forPattern(String pattern) {
        return new Builder(pattern);
    }

    public final String toPattern() {
        return this.pattern;
    }

    public final boolean isLenient() {
        return this.lenient;
    }

    public final TimeZone getTimeZone() {
        return (TimeZone)this.timeZone.clone();
    }

    public final Date parse(String source) throws ParseException {
        return this.parser.get().parse(source);
    }

    public final Date parse(String source, ParsePosition pos) {
        return this.parser.get().parse(source, pos);
    }

    public final String format(Date date) {
        return this.formatter.get().format(date);
    }

    public final StringBuffer format(Date date, StringBuffer toAppendTo, FieldPosition fieldPosition) {
        return this.formatter.get().format(date, toAppendTo, fieldPosition);
    }

    public final StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition fieldPosition) {
        return this.formatter.get().format(obj, toAppendTo, fieldPosition);
    }

    public static final class Builder {
        private final String pattern;
        private boolean lenient = true;
        private TimeZone timeZone = TimeZone.getDefault();

        public Builder(String pattern) {
            this.pattern = pattern;
            if (pattern == null) {
                throw new NullPointerException("Pattern cannot be null");
            }
        }

        public Builder setLenient(boolean lenient) {
            this.lenient = lenient;
            return this;
        }

        public Builder setUtcTimeZone() {
            this.timeZone = TimeZone.getTimeZone("UTC");
            return this;
        }

        public Builder setLocalTimeZone() {
            this.timeZone = TimeZone.getDefault();
            return this;
        }

        public Builder setTimeZone(String timeZoneId) {
            this.timeZone = TimeZone.getTimeZone(timeZoneId);
            return this;
        }

        public Builder setTimeZone(TimeZone timeZone) {
            this.timeZone = timeZone != null ? timeZone : TimeZone.getDefault();
            return this;
        }

        public SafeDateFormat build() {
            return new SafeDateFormat(this.pattern, this.lenient, this.timeZone);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class LocalFormat
    extends ThreadLocal<DateFormat> {
        LocalFormat() {
        }

        @Override
        protected DateFormat initialValue() {
            SimpleDateFormat format = new SimpleDateFormat(SafeDateFormat.this.toPattern());
            format.setLenient(SafeDateFormat.this.isLenient());
            format.setTimeZone(SafeDateFormat.this.getTimeZone());
            return format;
        }
    }
}

