/*
 * Decompiled with CFR 0.152.
 */
package org.progeeks.util;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.progeeks.util.DefaultObservableList;
import org.progeeks.util.ObjectUtils;
import org.progeeks.util.ObservableList;
import org.progeeks.util.beans.BeanChangeSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectedValue<T>
extends BeanChangeSupport
implements Serializable {
    static final long serialVersionUID = 1L;
    private T value;
    private ObservableList<T> choices = new DefaultObservableList<T>();
    private boolean strict;

    public SelectedValue() {
        this(null, Collections.emptyList());
    }

    public SelectedValue(List<T> choices) {
        this(null, choices);
    }

    public SelectedValue(T value, List<T> choices) {
        this(value, choices, true);
    }

    public SelectedValue(T value, List<T> choices, boolean strict) {
        this.setChoices(choices);
        this.setValue(value);
        this.setStrict(strict);
    }

    public void setChoices(List<T> choices) {
        if (this.choices == choices) {
            return;
        }
        this.choices.clear();
        if (choices != null) {
            this.choices.addAll(choices);
        }
    }

    public ObservableList<T> getChoices() {
        return this.choices;
    }

    public void setStrict(boolean b) {
        this.strict = b;
    }

    public boolean isStrict() {
        return this.strict;
    }

    public boolean isValidChoice(T value) {
        if (!this.strict) {
            return true;
        }
        return this.choices.indexOf(value) >= 0;
    }

    protected void selectChoice(int index, T value) {
        if (index < 0) {
            this.choices.add(value);
        }
    }

    public void setValue(T value) {
        if (ObjectUtils.areEqual(this.value, value)) {
            return;
        }
        T oldValue = value;
        int i = this.choices.indexOf(value);
        if (i < 0 && this.strict) {
            throw new IllegalArgumentException("Value[" + value + "] is not a valid choice.");
        }
        this.value = value;
        this.selectChoice(i, value);
        this.firePropertyChange("value", oldValue, value);
    }

    public T getValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }
}

