/*
 * Decompiled with CFR 0.152.
 */
package org.progeeks.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.progeeks.util.PropertyAccess;
import org.progeeks.util.beans.PropertyUtils;
import org.progeeks.util.el.DefaultAccessStack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleExpressionLanguage {
    private static final String[] STANDARD_EXAMPLES = new String[]{"foo.bar.baz", "foo.bar[42].baz", "foo\\.bar[42].baz", "foo\\\\.bar[42].baz", "foo.bar\\[42\\].baz", "foo.bar[].baz", "foo.\"bar.baz\"", "foo.(bar[12].baz)"};
    private PropertyAccess access;
    private boolean checkPropertyAccess = true;

    public SimpleExpressionLanguage() {
        this(DefaultAccessStack.createFullStack());
    }

    public SimpleExpressionLanguage(PropertyAccess access) {
        this.access = access;
    }

    public PropertyAccess getPropertyAccess() {
        return this.access;
    }

    public void setCheckPropertyAccess(boolean f) {
        this.checkPropertyAccess = f;
    }

    public boolean getCheckPropertyAccess() {
        return this.checkPropertyAccess;
    }

    public List<ExpressionElement> parseExpression(String expression) {
        ArrayList<ExpressionElement> results = new ArrayList<ExpressionElement>();
        SimpleTokenizer st = new SimpleTokenizer(expression, this.checkPropertyAccess);
        while (st.hasNext()) {
            results.add(st.next());
        }
        return results;
    }

    public Object getProperty(Object object, List<ExpressionElement> expressionElements) {
        for (ExpressionElement el : expressionElements) {
            if (object == null && !el.acceptsNullSource(this.access)) continue;
            object = el.get(this.access, object);
        }
        return object;
    }

    public Object getProperty(Object object, String expression) {
        return this.getProperty(object, this.parseExpression(expression));
    }

    public Class getPropertyClass(Object object, List<ExpressionElement> expressionElements) {
        ExpressionElement lastEl = null;
        Iterator<ExpressionElement> i = expressionElements.iterator();
        while (i.hasNext()) {
            lastEl = i.next();
            if (!i.hasNext()) break;
            if (object == null && !lastEl.acceptsNullSource(this.access)) continue;
            object = lastEl.get(this.access, object);
        }
        if (lastEl == null) {
            return null;
        }
        if (object == null && !lastEl.acceptsNullSource(this.access)) {
            return null;
        }
        return lastEl.getType(this.access, object);
    }

    public Class getPropertyClass(Object object, String expression) {
        return this.getPropertyClass(object, this.parseExpression(expression));
    }

    public boolean hasMutableProperty(Object object, List<ExpressionElement> expressionElements) {
        ExpressionElement lastEl = null;
        Iterator<ExpressionElement> i = expressionElements.iterator();
        while (i.hasNext()) {
            lastEl = i.next();
            if (!i.hasNext()) break;
            if (object == null && !lastEl.acceptsNullSource(this.access)) continue;
            object = lastEl.get(this.access, object);
        }
        if (lastEl == null) {
            return false;
        }
        if (object == null && !lastEl.acceptsNullSource(this.access)) {
            return false;
        }
        return lastEl.isMutable(this.access, object);
    }

    public boolean hasMutableProperty(Object object, String expression) {
        return this.hasMutableProperty(object, this.parseExpression(expression));
    }

    public void setProperty(Object object, String expression, Object value) {
        this.setProperty(object, this.parseExpression(expression), value);
    }

    public void setProperty(Object object, List<ExpressionElement> expressionElements, Object value) {
        ExpressionElement lastEl = null;
        int element = 0;
        Iterator<ExpressionElement> i = expressionElements.iterator();
        while (i.hasNext()) {
            ExpressionElement el = i.next();
            if (!i.hasNext()) {
                lastEl = el;
                break;
            }
            if ((object = el.get(this.access, object)) == null) {
                String exp = this.elementsToString(expressionElements.subList(0, element + 1));
                throw new RuntimeException("Expression part [" + exp + "] is null.");
            }
            ++element;
        }
        lastEl.set(this.access, object, value);
    }

    public String elementsToString(List<?> expressions) {
        StringBuffer sb = new StringBuffer();
        for (ExpressionElement el : expressions) {
            if (el instanceof NamedExpressionElement) {
                if (sb.length() > 0) {
                    sb.append('.');
                }
                String name = ((NamedExpressionElement)el).getName();
                name = name.replaceAll("\\\\", "\\\\\\\\");
                name = name.replaceAll("\\.", "\\\\.");
                name = name.replaceAll("\\[", "\\\\[");
                name = name.replaceAll("\\]", "\\\\]");
                sb.append(name);
                continue;
            }
            if (!(el instanceof IndexedExpressionElement)) continue;
            sb.append('[');
            int index = ((IndexedExpressionElement)el).getIndex();
            sb.append(index >= 0 ? String.valueOf(index) : "");
            sb.append(']');
        }
        return sb.toString();
    }

    protected static String prepadString(String value, char pad, int size) {
        StringBuilder sb = new StringBuilder();
        size -= value.length();
        while (sb.length() < size) {
            sb.append(pad);
        }
        sb.append(value);
        return sb.toString();
    }

    protected static String createSyntaxErrorMessage(String value, int position) {
        StringBuffer sb = new StringBuffer("Syntax error in expression:\n");
        sb.append(value);
        sb.append("\n");
        sb.append(SimpleExpressionLanguage.prepadString("", ' ', position));
        sb.append('^');
        return sb.toString();
    }

    public static void main(String[] args) throws Exception {
        String[] strings = args.length == 0 ? STANDARD_EXAMPLES : args;
        SimpleExpressionLanguage el = PropertyUtils.EL;
        for (int i = 0; i < strings.length; ++i) {
            try {
                System.out.println("Parsing:" + strings[i]);
                List<ExpressionElement> results = el.parseExpression(strings[i]);
                Iterator<ExpressionElement> it = results.iterator();
                while (it.hasNext()) {
                    System.out.println("    " + it.next());
                }
                System.out.println("Unparsed:" + el.elementsToString(results));
                continue;
            }
            catch (RuntimeException e) {
                e.printStackTrace();
            }
        }
    }

    protected static class SimpleTokenizer {
        private char[] buffer;
        private int pos;
        private int lastStart;
        private boolean inBrackets = false;
        private boolean checkAccess = false;

        public SimpleTokenizer(String s, boolean checkAccess) {
            this(s.toCharArray());
            this.checkAccess = checkAccess;
        }

        public SimpleTokenizer(char[] buffer) {
            this.buffer = buffer;
        }

        protected void pushBack() {
            --this.pos;
        }

        protected int peak() {
            if (this.pos < this.buffer.length) {
                return this.buffer[this.pos];
            }
            return -1;
        }

        protected int read() {
            if (this.pos < this.buffer.length) {
                return this.buffer[this.pos++];
            }
            return -1;
        }

        protected RuntimeException error(String message) {
            return this.error(message, null);
        }

        protected RuntimeException error(String message, Throwable cause) {
            int index = this.pos - 1;
            StringBuilder sb = new StringBuilder(message + "  Offset:" + index);
            sb.append("\n");
            sb.append(new String(this.buffer));
            sb.append("\n");
            sb.append(SimpleExpressionLanguage.prepadString("", ' ', index));
            sb.append("^");
            return new RuntimeException(sb.toString(), cause);
        }

        protected StringBuilder fetch(String stops, String bad, boolean mustTerminate) {
            int val;
            if (this.pos >= this.buffer.length) {
                return null;
            }
            this.lastStart = this.pos;
            StringBuilder sb = new StringBuilder();
            boolean inQuotes = false;
            boolean inParens = false;
            int start = this.pos;
            while ((val = this.read()) >= 0) {
                char c = (char)val;
                if (c == '\\') {
                    int lookahead = this.read();
                    if (lookahead >= 0) {
                        sb.append((char)lookahead);
                        continue;
                    }
                    throw this.error("Found escape character '\\' with no trailing character.");
                }
                switch (c) {
                    case '(': {
                        if (inQuotes) break;
                        inParens = true;
                        break;
                    }
                    case ')': {
                        if (!inQuotes && inParens) {
                            inParens = false;
                            break;
                        }
                        if (inParens) break;
                        throw this.error("Found ')' with no matching '('.");
                    }
                    case '\"': {
                        boolean bl = inQuotes = !inQuotes;
                    }
                }
                if (!inQuotes && !inParens) {
                    if (stops.indexOf(c) >= 0) {
                        this.pushBack();
                        return sb;
                    }
                    if (bad.indexOf(c) >= 0) {
                        throw this.error("Parse error, encountered invalid character: '" + c + "'");
                    }
                }
                sb.append(c);
            }
            if (mustTerminate) {
                throw this.error("End of string reached without terminator.");
            }
            return sb;
        }

        protected ExpressionElement readIndexedElement() {
            this.read();
            StringBuilder sb = this.fetch("]", "[.", true);
            this.read();
            if (this.peak() == 46) {
                this.read();
            }
            if (sb.length() > 0) {
                try {
                    Integer index = new Integer(sb.toString());
                    return new IndexedExpressionElement(index);
                }
                catch (Exception e) {
                    throw this.error("Error parsing index.", e);
                }
            }
            return new IndexedExpressionElement(Integer.MAX_VALUE);
        }

        protected ExpressionElement readNamedElement() {
            StringBuilder sb = this.fetch(".[", "]", false);
            if (this.peak() == 46) {
                this.read();
            }
            return new NamedExpressionElement(sb.toString(), this.checkAccess);
        }

        public boolean hasNext() {
            return this.pos < this.buffer.length;
        }

        public ExpressionElement next() {
            if (this.pos >= this.buffer.length) {
                return null;
            }
            int peak = this.peak();
            switch (peak) {
                case -1: {
                    return null;
                }
                case 91: {
                    return this.readIndexedElement();
                }
            }
            return this.readNamedElement();
        }
    }

    public static class IndexedExpressionElement
    implements ExpressionElement {
        public static final int EMPTY_INDEX = Integer.MAX_VALUE;
        private int index;

        public IndexedExpressionElement(int index) {
            this.index = index;
        }

        public boolean isEmptyIndex() {
            return this.index == Integer.MAX_VALUE;
        }

        public int getIndex() {
            return this.index;
        }

        public String toString() {
            return "{" + (this.index != Integer.MAX_VALUE ? String.valueOf(this.index) : "end") + "}";
        }

        public Object get(PropertyAccess access, Object object) {
            int actualIndex;
            int size;
            if (this.index < 0) {
                throw new RuntimeException("Negative indexing for read access is not currently supported.");
            }
            int relativeIndex = this.index == Integer.MAX_VALUE ? -1 : this.index;
            if (relativeIndex >= (size = this.getSize(object)) || -relativeIndex > size) {
                return null;
            }
            int n = actualIndex = relativeIndex >= 0 ? relativeIndex : size + relativeIndex;
            if (object.getClass().isArray()) {
                return Array.get(object, actualIndex);
            }
            if (object instanceof List) {
                return ((List)object).get(actualIndex);
            }
            if (object instanceof Collection) {
                Collection c = (Collection)object;
                Iterator iter = c.iterator();
                for (int curIndex = 0; curIndex < actualIndex; ++curIndex) {
                    iter.next();
                }
                return iter.next();
            }
            throw new RuntimeException("Cannot use indexed expression on type:" + object.getClass());
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void set(PropertyAccess access, Object object, Object value) {
            if (this.index < 0) {
                throw new RuntimeException("Negative indexing for write access is not currently supported.");
            }
            if (object.getClass().isArray()) {
                if (this.index == Integer.MAX_VALUE) {
                    throw new RuntimeException("End of list expression \"[]\" not allowed for write access upon arrays.");
                }
                Array.set(object, this.index, value);
                return;
            } else if (object instanceof List) {
                List list = (List)object;
                if (this.index == Integer.MAX_VALUE) {
                    list.add(value);
                    return;
                } else if (this.index < list.size()) {
                    list.set(this.index, value);
                    return;
                } else {
                    while (list.size() < this.index) {
                        list.add(null);
                    }
                    list.add(value);
                }
                return;
            } else {
                if (!(object instanceof Collection)) throw new RuntimeException("Cannot use indexed expression on type:" + object.getClass());
                if (this.index != Integer.MAX_VALUE) throw new RuntimeException("Can only append values to " + object.getClass());
                ((Collection)object).add(value);
            }
        }

        protected int getSize(Object object) {
            if (object == null) {
                return 0;
            }
            if (object.getClass().isArray()) {
                return Array.getLength(object);
            }
            if (object instanceof Collection) {
                return ((Collection)object).size();
            }
            if (object instanceof Map) {
                return ((Map)object).size();
            }
            if (object instanceof String) {
                return ((String)object).length();
            }
            return 1;
        }

        public Class getType(PropertyAccess acces, Object object) {
            return Object.class;
        }

        public boolean isMutable(PropertyAccess access, Object object) {
            if (this.index < 0) {
                return false;
            }
            if (object.getClass().isArray()) {
                return this.index != Integer.MAX_VALUE;
            }
            if (object instanceof List) {
                return true;
            }
            if (object instanceof Collection) {
                return this.index == Integer.MAX_VALUE;
            }
            return false;
        }

        public boolean acceptsNullSource(PropertyAccess access) {
            return false;
        }
    }

    public static class NamedExpressionElement
    implements ExpressionElement {
        private String name;
        private boolean checkAccess;

        public NamedExpressionElement(String name, boolean checkAccess) {
            this.name = name;
            this.checkAccess = checkAccess;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }

        public Object get(PropertyAccess access, Object object) {
            if (!access.hasProperty(object, this.name)) {
                if (this.checkAccess) {
                    throw new RuntimeException("Property[" + this.name + "] not defined on:" + object + "  type:" + (object != null ? object.getClass() : "null"));
                }
                return null;
            }
            return access.getProperty(object, this.name);
        }

        public void set(PropertyAccess access, Object object, Object value) {
            access.setProperty(object, this.name, value);
        }

        public Class getType(PropertyAccess access, Object object) {
            return access.getPropertyClass(object, this.name);
        }

        public boolean isMutable(PropertyAccess access, Object object) {
            return access.hasMutableProperty(object, this.name);
        }

        public boolean acceptsNullSource(PropertyAccess access) {
            return access.acceptsNullSource(this.name);
        }
    }

    public static interface ExpressionElement {
        public Object get(PropertyAccess var1, Object var2);

        public void set(PropertyAccess var1, Object var2, Object var3);

        public Class getType(PropertyAccess var1, Object var2);

        public boolean isMutable(PropertyAccess var1, Object var2);

        public boolean acceptsNullSource(PropertyAccess var1);
    }
}

