/*
 * Decompiled with CFR 0.152.
 */
package org.progeeks.util;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.progeeks.util.ObjectUtils;
import org.progeeks.util.SimpleExpressionLanguage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateExpressionProcessor {
    public static final String[] STANDARD_EXAMPLES = new String[]{"Beginning ${var.expression} ending.", "An escaped \\${not.an} expression.", "An expression ${with.stuff\\{embedded\\}} in it.", "One expression ${expression.one} and another ${expression.two}.", "Expression with an ${indexed[12].expression} in it.", "Expression with an ${things\\.escaped\\.and.stuff} in it.", "An expression ${with.some.${nesting}} and a trailing ${expression}"};
    private static final String TOKEN_EXPRESSION = "(?<!\\\\)(\\$\\{|\\})";
    private static final Pattern TOKEN_PATTERN = Pattern.compile("(?<!\\\\)(\\$\\{|\\})");
    private static ThreadLocal<TemplateExpressionProcessor> threadContextProcessor = new ThreadLocal();
    private static TemplateExpressionProcessor defaultProcessor = new TemplateExpressionProcessor();
    private Object target;
    private SimpleExpressionLanguage expressionLang;

    public TemplateExpressionProcessor() {
        this(null, new SimpleExpressionLanguage());
    }

    public TemplateExpressionProcessor(SimpleExpressionLanguage el) {
        this(null, el);
    }

    public TemplateExpressionProcessor(Object target, SimpleExpressionLanguage el) {
        this.target = target;
        this.expressionLang = el;
    }

    public static void setContextProcessor(TemplateExpressionProcessor proc) {
        threadContextProcessor.set(proc);
    }

    public static TemplateExpressionProcessor getContextProcessor() {
        TemplateExpressionProcessor result = threadContextProcessor.get();
        if (result != null) {
            return result;
        }
        return defaultProcessor;
    }

    public static void setDefaultProcessor(TemplateExpressionProcessor proc) {
        defaultProcessor = proc;
    }

    public static TemplateExpressionProcessor getDefaultProcessor() {
        return defaultProcessor;
    }

    protected Object lookupValue(Object obj, String expression) {
        return this.expressionLang.getProperty(obj, expression);
    }

    public void setTarget(Object target) {
        this.target = target;
    }

    public Object getTarget() {
        return this.target;
    }

    public SimpleExpressionLanguage getExpressionLanguage() {
        return this.expressionLang;
    }

    protected Object evaluateElement(Object target, Object element) {
        if (element instanceof ReferenceElement) {
            return this.lookupValue(target, ((ReferenceElement)element).getExpression());
        }
        if (element instanceof NestedExpressionElement) {
            NestedExpressionElement el = (NestedExpressionElement)element;
            String s = String.valueOf(this.evaluateElements(target, el.getElements()));
            return this.lookupValue(target, s);
        }
        return element;
    }

    protected StringBuffer evaluateElements(Object target, List elements) {
        StringBuffer sb = new StringBuffer();
        for (Object el : elements) {
            sb.append(this.evaluateElement(target, el));
        }
        return sb;
    }

    public Object evaluate(TemplateExpression exp) {
        return this.evaluate(this.getTarget(), exp);
    }

    public Object evaluate(String exp) {
        return this.evaluate(this.getTarget(), exp);
    }

    public Object evaluate(Object target, TemplateExpression exp) {
        List<Object> elements = exp.getElements();
        if (elements.size() == 1) {
            return this.evaluateElement(target, elements.get(0));
        }
        return this.evaluateElements(target, elements);
    }

    public Object evaluate(Object target, String exp) {
        List<Object> elements = TemplateExpressionProcessor.parseExpression(exp);
        if (elements.size() == 1) {
            return this.evaluateElement(target, elements.get(0));
        }
        return this.evaluateElements(target, elements);
    }

    public static Object evaluateTemplateExpression(TemplateExpression exp) {
        TemplateExpressionProcessor proc = TemplateExpressionProcessor.getContextProcessor();
        if (proc == null) {
            throw new RuntimeException("A thread context template processor has not been set.");
        }
        return proc.evaluate(exp);
    }

    public static Object evaluateTemplateExpression(String exp) {
        TemplateExpressionProcessor proc = TemplateExpressionProcessor.getContextProcessor();
        if (proc == null) {
            throw new RuntimeException("A thread context template processor has not been set.");
        }
        return proc.evaluate(exp);
    }

    public static Object evaluateTemplateExpression(Object target, TemplateExpression exp) {
        TemplateExpressionProcessor proc = TemplateExpressionProcessor.getContextProcessor();
        if (proc == null) {
            throw new RuntimeException("A thread context template processor has not been set.");
        }
        return proc.evaluate(target, exp);
    }

    public static Object evaluateTemplateExpression(Object target, String exp) {
        TemplateExpressionProcessor proc = TemplateExpressionProcessor.getContextProcessor();
        if (proc == null) {
            throw new RuntimeException("A thread context template processor has not been set.");
        }
        return proc.evaluate(target, exp);
    }

    private static List<Object> parseExpression(String exp) {
        Matcher m = TOKEN_PATTERN.matcher(exp);
        List<Object> list = TemplateExpressionProcessor.parseExpression(m, 0, exp, 0);
        return list;
    }

    private static List<Object> parseExpression(Matcher m, int previous, String exp, int deep) {
        ArrayList<Object> list = new ArrayList<Object>();
        int start = previous;
        while (m.find()) {
            String pre = exp.substring(previous, m.start());
            if (pre.length() > 0) {
                list.add(pre);
            }
            int pos = m.start();
            String s = m.group(1);
            if (s.equals("${")) {
                List<Object> l = TemplateExpressionProcessor.parseExpression(m, m.end(), exp, deep + 1);
                if (l == null) {
                    throw new RuntimeException("Unterminated reference starting at position:" + pos + "  In expression:" + exp);
                }
                Object el = l.size() == 1 ? new ReferenceElement((String)l.get(0)) : new NestedExpressionElement(l);
                list.add(el);
            } else {
                if (deep > 0 && s.equals("}")) {
                    return list;
                }
                list.add(s);
            }
            previous = m.end();
        }
        if (deep > 0) {
            return null;
        }
        String end = exp.substring(previous);
        if (end.length() > 0) {
            list.add(end);
        }
        return list;
    }

    public static String expressionToString(TemplateExpression exp) {
        return TemplateExpressionProcessor.expressionToString(exp.getElements());
    }

    private static String expressionToString(List<?> elements) {
        StringBuffer sb = new StringBuffer();
        for (Object o : elements) {
            if (o instanceof ReferenceElement) {
                sb.append("${" + ((ReferenceElement)o).getExpression() + "}");
                continue;
            }
            if (o instanceof NestedExpressionElement) {
                sb.append("${" + TemplateExpressionProcessor.expressionToString(((NestedExpressionElement)o).getElements()) + "}");
                continue;
            }
            sb.append(o);
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        String[] strings = args.length == 0 ? STANDARD_EXAMPLES : args;
        for (int i = 0; i < strings.length; ++i) {
            System.out.println("Parsing:" + strings[i]);
            TemplateExpression exp = new TemplateExpression(strings[i]);
            System.out.println("parsed:" + exp);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NestedExpressionElement {
        private List<Object> elements;

        public NestedExpressionElement(List<Object> elements) {
            this.elements = elements;
        }

        public List<Object> getElements() {
            return this.elements;
        }

        public String toString() {
            return "NestedExpression[" + this.elements + "]";
        }
    }

    public static class ReferenceElement {
        private String expression;

        public ReferenceElement(String expression) {
            this.expression = expression;
        }

        public String getExpression() {
            return this.expression;
        }

        public String toString() {
            return "Reference[" + this.expression + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TemplateExpression<T> {
        private String expression;
        private List<Object> elements;

        public TemplateExpression() {
        }

        public TemplateExpression(String expression) {
            this.setExpression(expression);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o == null) {
                return false;
            }
            if (o.getClass() != this.getClass()) {
                return false;
            }
            TemplateExpression te = (TemplateExpression)o;
            return ObjectUtils.areEqual(te.expression, this.expression);
        }

        public int hashCode() {
            return this.expression.hashCode();
        }

        protected TemplateExpression(List<Object> elements) {
            this.elements = elements;
            this.expression = TemplateExpressionProcessor.expressionToString(elements);
        }

        public String getExpression() {
            return this.expression;
        }

        public void setExpression(String expression) {
            this.expression = expression;
            this.elements = TemplateExpressionProcessor.parseExpression(expression);
        }

        public List<Object> getElements() {
            return this.elements;
        }

        public String toString() {
            return "TemplateExpression" + this.elements;
        }
    }
}

