/*
 * Decompiled with CFR 0.152.
 */
package org.progeeks.util;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import org.progeeks.util.Inspector;
import org.progeeks.util.beans.StandardBean;
import org.progeeks.util.log.Log;

public class WeakPropertyChangeListener
implements PropertyChangeListener {
    static Log log = Log.getLog(WeakPropertyChangeListener.class);
    private static final String REMOVE_METHOD_NAME = "removePropertyChangeListener";
    private static final Class[] REMOVE_GENERAL_LISTENER_PARAM_TYPES = new Class[]{PropertyChangeListener.class};
    private static final Class[] REMOVE_SPECIFIC_LISTENER_PARAM_TYPES = new Class[]{String.class, PropertyChangeListener.class};
    private WeakReference<PropertyChangeListener> delegate;

    public WeakPropertyChangeListener(PropertyChangeListener delegate) {
        this.delegate = new WeakReference<PropertyChangeListener>(delegate);
    }

    protected void removeFromSource(PropertyChangeEvent event) {
        Object src = event.getSource();
        if (log.isDebugEnabled()) {
            log.debug(this.toString() + "->Automatically removing:" + this + " from:" + src);
        }
        if (src instanceof StandardBean) {
            ((StandardBean)src).removePropertyChangeListener(this, true);
        } else {
            boolean removeFound = false;
            Inspector inspector = new Inspector(src);
            if (inspector.hasMethod(REMOVE_METHOD_NAME, REMOVE_GENERAL_LISTENER_PARAM_TYPES)) {
                removeFound = true;
                inspector.callMethod(REMOVE_METHOD_NAME, this);
            }
            if (inspector.hasMethod(REMOVE_METHOD_NAME, REMOVE_SPECIFIC_LISTENER_PARAM_TYPES)) {
                removeFound = true;
                inspector.callMethod(REMOVE_METHOD_NAME, event.getPropertyName(), this);
            }
            if (!removeFound) {
                log.warn("Did not find remove listener method for non-standard bean.");
            }
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        PropertyChangeListener listener = (PropertyChangeListener)this.delegate.get();
        if (listener == null) {
            this.removeFromSource(event);
            return;
        }
        listener.propertyChange(event);
    }
}

