/*
 * Decompiled with CFR 0.152.
 */
package org.progeeks.util.beans;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.progeeks.util.beans.StandardBean;
import org.progeeks.util.log.Log;

public class BeanChangeSupport
implements StandardBean {
    static Log log = Log.getLog(BeanChangeSupport.class);
    private transient List<PropertyChangeListener> listeners;
    private transient Map<String, List<PropertyChangeListener>> children;
    private Object source;

    public BeanChangeSupport() {
        this.source = this;
    }

    public BeanChangeSupport(Object source) {
        this.source = source;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        if (log.isDebugEnabled()) {
            log.debug("addPropertyChangeListener(" + l + ") to:" + this + " id hash:" + System.identityHashCode(this));
        }
        if (this.listeners == null) {
            this.listeners = new ArrayList<PropertyChangeListener>();
        }
        this.listeners.add(l);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener l) {
        List<PropertyChangeListener> child;
        if (log.isDebugEnabled()) {
            log.debug("addPropertyChangeListener(" + propertyName + ", " + l + ") to:" + this + " id hash:" + System.identityHashCode(this));
        }
        if (this.children == null) {
            this.children = new HashMap<String, List<PropertyChangeListener>>();
        }
        if ((child = this.children.get(propertyName)) == null) {
            child = new ArrayList<PropertyChangeListener>();
            this.children.put(propertyName, child);
        }
        child.add(l);
    }

    public boolean hasListeners(String propertyName) {
        if (this.children == null) {
            return false;
        }
        List<PropertyChangeListener> child = this.children.get(propertyName);
        return child != null && child.size() != 0;
    }

    public boolean hasListeners() {
        return this.listeners != null && !this.listeners.isEmpty() || this.children != null && !this.children.isEmpty();
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.removePropertyChangeListener(l, false);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener l) {
        if (this.children == null) {
            return;
        }
        List<PropertyChangeListener> child = this.children.get(propertyName);
        if (child == null) {
            return;
        }
        child.remove(l);
        if (child.isEmpty()) {
            this.children.remove(propertyName);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener l, boolean removeAll) {
        if (this.listeners != null) {
            while (this.listeners.remove(l) && removeAll) {
            }
        }
        if (!removeAll || this.children == null) {
            return;
        }
        Iterator<List<PropertyChangeListener>> i = this.children.values().iterator();
        while (i.hasNext()) {
            List<PropertyChangeListener> list = i.next();
            while (list.remove(l)) {
            }
            if (!list.isEmpty()) continue;
            i.remove();
        }
    }

    public void clearAllListeners() {
        if (this.listeners != null) {
            this.listeners.clear();
        }
        if (this.children != null) {
            this.children.clear();
        }
    }

    protected void firePropertyChange(PropertyChangeEvent event) {
        Object newValue;
        Object oldValue = event.getOldValue();
        if (oldValue == (newValue = event.getNewValue()) || oldValue != null && oldValue.equals(newValue)) {
            return;
        }
        this.firePropertyChange(event.getPropertyName(), oldValue, newValue, event);
    }

    protected void firePropertyChange(String name, boolean oldValue, boolean newValue) {
        if (oldValue == newValue) {
            return;
        }
        this.firePropertyChange(name, oldValue, newValue, null);
    }

    protected void firePropertyChange(String name, double oldValue, double newValue) {
        if (oldValue == newValue) {
            return;
        }
        this.firePropertyChange(name, new Double(oldValue), new Double(newValue), null);
    }

    protected void firePropertyChange(String name, int oldValue, int newValue) {
        if (oldValue == newValue) {
            return;
        }
        this.firePropertyChange(name, new Integer(oldValue), new Integer(newValue), null);
    }

    protected void firePropertyChange(String name, Object oldValue, Object newValue) {
        if (oldValue == newValue || oldValue != null && oldValue.equals(newValue)) {
            return;
        }
        this.firePropertyChange(name, oldValue, newValue, null);
    }

    private void firePropertyChange(String name, Object oldValue, Object newValue, PropertyChangeEvent event) {
        List<PropertyChangeListener> realChild;
        PropertyChangeListener[] targets = null;
        PropertyChangeListener[] child = null;
        if (this.listeners != null && this.listeners.size() > 0) {
            targets = new PropertyChangeListener[this.listeners.size()];
            targets = this.listeners.toArray(targets);
        }
        if (this.children != null && (realChild = this.children.get(name)) != null && realChild.size() > 0) {
            child = new PropertyChangeListener[realChild.size()];
            child = realChild.toArray(child);
        }
        if (targets == null && child == null) {
            return;
        }
        if (event == null) {
            event = new PropertyChangeEvent(this.source, name, oldValue, newValue);
        }
        if (log.isDebugEnabled()) {
            log.debug("BeanChangeSupport(" + this.toString() + ").fire(" + name + ", " + oldValue + ", " + newValue + " )");
        }
        if (targets != null) {
            if (log.isDebugEnabled()) {
                log.debug("  " + targets.length + " targets...");
            }
            for (int i = 0; i < targets.length; ++i) {
                if (log.isDebugEnabled()) {
                    log.debug("delivering to:" + targets[i]);
                }
                targets[i].propertyChange(event);
            }
        }
        if (child != null) {
            if (log.isDebugEnabled()) {
                log.debug("  " + child.length + " children...");
            }
            for (int i = 0; i < child.length; ++i) {
                if (log.isDebugEnabled()) {
                    log.debug("    delivering to:" + child[i]);
                }
                child[i].propertyChange(event);
            }
        }
    }
}

