/*
 * Decompiled with CFR 0.152.
 */
package org.progeeks.util.beans;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import org.progeeks.util.AbstractObjectConfigurator;
import org.progeeks.util.Inspector;
import org.progeeks.util.ObjectUtils;
import org.progeeks.util.PropertyAccess;
import org.progeeks.util.beans.BeanPropertyAdapter;
import org.progeeks.util.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanConfigurator<V>
extends AbstractObjectConfigurator<V>
implements Serializable {
    static final long serialVersionUID = 1L;
    static Log log = Log.getLog(BeanConfigurator.class);
    private static PropertyAccess defaultAccess = BeanPropertyAdapter.getInstance();
    private Class beanClass;

    public BeanConfigurator() {
        this((Class)null);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        BeanConfigurator bc = (BeanConfigurator)obj;
        if (!ObjectUtils.areEqual(this.beanClass, bc.beanClass)) {
            return false;
        }
        if (this.getAppendCollections() != bc.getAppendCollections()) {
            return false;
        }
        if (this.getOverwriteExistingValues() != bc.getOverwriteExistingValues()) {
            return false;
        }
        return super.equals(obj);
    }

    public BeanConfigurator(Class beanClass) {
        super(defaultAccess);
        this.setBeanClass(beanClass);
    }

    public BeanConfigurator(BeanConfigurator<V> factory) {
        this(factory.getBeanClass());
        this.putAll(factory);
        this.setAppendCollections(factory.getAppendCollections());
        this.setOverwriteExistingValues(factory.getOverwriteExistingValues());
        this.setAppendFactories(factory.getAppendFactories());
        this.setReuseFactoryResults(factory.getReuseFactoryResults());
        this.setReusable(factory.isReusable());
    }

    public static void setDefaultPropertyAccess(PropertyAccess access) {
        defaultAccess = access;
    }

    public static PropertyAccess getDefaultPropertyAccess() {
        return defaultAccess;
    }

    @Override
    public void setPropertyAccess(PropertyAccess access) {
        super.setPropertyAccess(access);
    }

    @Override
    public PropertyAccess getPropertyAccess() {
        return super.getPropertyAccess();
    }

    protected void setBeanClass(Class type) {
        this.beanClass = type;
        if (this.beanClass != null && this.beanClass.isInterface()) {
            throw new RuntimeException("Invalid class:" + this.beanClass + "  Classes must be concrete.");
        }
    }

    public Class getBeanClass() {
        return this.beanClass;
    }

    @Deprecated
    public final void configureBean(V bean) {
        this.configureObject(bean, null);
    }

    @Deprecated
    public final V createBean() {
        return this.createObject(new Object[0]);
    }

    @Override
    protected V newInstance(Object ... args) {
        if (this.beanClass == null) {
            throw new RuntimeException("Configurator does not have an associated bean type.");
        }
        if (log.isDebugEnabled()) {
            log.debug("newInstance() : " + this.beanClass);
        }
        Object obj = args != null && args.length > 0 ? Inspector.newInstance(this.beanClass, args) : Inspector.newInstance(this.beanClass);
        return (V)obj;
    }

    @Deprecated
    public final Object createBean(Object[] args) {
        return this.createObject(null, args);
    }

    public boolean hasConstructor(Object[] args) {
        Class[] types = new Class[args.length];
        for (int i = 0; i < types.length; ++i) {
            types[i] = args[i].getClass();
        }
        return this.hasConstructor(types);
    }

    public boolean hasConstructor(Class[] types) {
        if (this.beanClass == null) {
            throw new RuntimeException("Configurator does not have an associated bean type.");
        }
        return Inspector.hasOverloadedConstructor(this.beanClass, types);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.setPropertyAccess(BeanConfigurator.getDefaultPropertyAccess());
    }

    @Override
    public String toString() {
        return "BeanConfigurator[ beanClass=" + this.beanClass + ", properties=" + super.toString() + " ]";
    }
}

