/*
 * Decompiled with CFR 0.152.
 */
package org.progeeks.util.beans;

import java.beans.BeanInfo;
import java.beans.EventSetDescriptor;
import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.progeeks.util.beans.ContainerPropertyDescriptor;
import org.progeeks.util.beans.StandardBean;
import org.progeeks.util.log.Log;
import org.progeeks.util.log.LogLevel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanInspector {
    static Log log = Log.getLog(BeanInspector.class);
    private static Map<Class, BeanInspector> inspectorCache = new HashMap<Class, BeanInspector>();
    private Class beanClass;
    private Map<String, PropertyDescriptor> descriptors = new HashMap<String, PropertyDescriptor>();
    private Method addListenerMethod;
    private Method removeListenerMethod;

    public static synchronized BeanInspector getInspector(Class c) {
        BeanInspector retVal = inspectorCache.get(c);
        if (retVal == null) {
            if (log.isDebugEnabled()) {
                log.debug("Caching inspector for:" + c);
            }
            Class notPrivateClass = c;
            while (Modifier.isPrivate(notPrivateClass.getModifiers())) {
                notPrivateClass = notPrivateClass.getSuperclass();
            }
            retVal = new BeanInspector(notPrivateClass);
            inspectorCache.put(c, retVal);
        }
        return retVal;
    }

    public static void releaseInspector(Class c) {
        inspectorCache.remove(c);
    }

    protected BeanInspector(Class beanClass) {
        this.beanClass = beanClass;
        try {
            this.cacheDescriptors();
        }
        catch (IntrospectionException e) {
            throw new RuntimeException("Error getting class descriptors for:" + beanClass, e);
        }
    }

    protected void cacheDescriptors() throws IntrospectionException {
        if (log.isInfoEnabled()) {
            log.info("Caching descriptors for bean type:" + this.beanClass.getName());
        }
        BeanInfo info = Introspector.getBeanInfo(this.beanClass);
        EventSetDescriptor[] events = info.getEventSetDescriptors();
        for (int i = 0; i < events.length; ++i) {
            if (!"propertyChange".equals(events[i].getName())) continue;
            this.addListenerMethod = (Method)BeanInspector.verifyAccess(events[i].getAddListenerMethod());
            this.removeListenerMethod = (Method)BeanInspector.verifyAccess(events[i].getRemoveListenerMethod());
        }
        PropertyDescriptor[] props = info.getPropertyDescriptors();
        for (int i = 0; i < props.length; ++i) {
            if ("class".equals(props[i].getName())) continue;
            Class<?> type = props[i].getPropertyType();
            if (type == null && props[i] instanceof IndexedPropertyDescriptor) {
                IndexedPropertyDescriptor ipd = (IndexedPropertyDescriptor)props[i];
                log.info("Indexed property skipped:" + ipd.getName() + "  type:" + ipd.getIndexedPropertyType() + "  indexed getter:" + ipd.getIndexedReadMethod());
                continue;
            }
            if (ContainerPropertyDescriptor.isContainerType(type)) {
                props[i] = new ContainerPropertyDescriptor(this.beanClass, props[i]);
            } else {
                BeanInspector.verifyAccess(props[i].getReadMethod());
                BeanInspector.verifyAccess(props[i].getWriteMethod());
            }
            if (log.isInfoEnabled()) {
                log.info("property[" + props[i].getName() + "]  type:" + props[i].getPropertyType());
            }
            this.descriptors.put(props[i].getName(), props[i]);
        }
    }

    protected static AccessibleObject verifyAccess(AccessibleObject obj) {
        if (obj == null) {
            return null;
        }
        if (obj.isAccessible()) {
            return obj;
        }
        obj.setAccessible(true);
        return obj;
    }

    public Class getBeanClass() {
        return this.beanClass;
    }

    public boolean isWriteableProperty(String property) {
        PropertyDescriptor desc = this.getDescriptor(property);
        if (desc == null) {
            return false;
        }
        return desc.getWriteMethod() != null;
    }

    public boolean isMutableProperty(String property) {
        PropertyDescriptor desc = this.getDescriptor(property);
        if (desc == null) {
            return false;
        }
        if (desc.getWriteMethod() != null) {
            return true;
        }
        if (desc instanceof ContainerPropertyDescriptor) {
            return ((ContainerPropertyDescriptor)desc).isResizable();
        }
        return false;
    }

    public boolean isReadableProperty(String property) {
        PropertyDescriptor desc = this.getDescriptor(property);
        if (desc == null) {
            return false;
        }
        return desc.getReadMethod() != null;
    }

    public void setProperty(Object bean, String property, Object value) {
        PropertyDescriptor desc = this.getDescriptor(property);
        if (desc == null) {
            throw new RuntimeException("Property not found:" + property);
        }
        try {
            Method m = desc.getWriteMethod();
            if (m == null) {
                throw new RuntimeException("Property is read-only:" + property);
            }
            m.invoke(bean, value);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Error setting property:" + property, e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Error setting property:" + property, e);
        }
    }

    public Class getPropertyType(String property) {
        PropertyDescriptor desc = this.getDescriptor(property);
        if (desc == null) {
            return null;
        }
        return desc.getPropertyType();
    }

    public Object getProperty(Object bean, String property) {
        PropertyDescriptor desc = this.getDescriptor(property);
        if (desc == null) {
            throw new RuntimeException("Property not found:" + property + "  class:" + this.beanClass);
        }
        try {
            Method m = desc.getReadMethod();
            if (m == null) {
                throw new RuntimeException("Property is write-only:" + property);
            }
            return m.invoke(bean, (Object[])null);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Error getting property:" + property, e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Error getting property:" + property, e);
        }
    }

    public boolean isListProperty(String property) {
        PropertyDescriptor desc = this.descriptors.get(property);
        if (!(desc instanceof ContainerPropertyDescriptor)) {
            return false;
        }
        return ((ContainerPropertyDescriptor)desc).isList();
    }

    public boolean isContainerProperty(String property) {
        return this.descriptors.get(property) instanceof ContainerPropertyDescriptor;
    }

    public List<Object> getListProperty(Object bean, String property) {
        return (List)this.getProperty(bean, property);
    }

    public boolean addPropertyElement(Object bean, String property, Object value) {
        ContainerPropertyDescriptor desc = this.getContainerDescriptor(property);
        if (desc == null) {
            throw new RuntimeException("Property not found:" + property);
        }
        Method m = desc.getAddMethod();
        if (m != null) {
            try {
                Object ret = m.invoke(bean, value);
                if (ret instanceof Boolean) {
                    return (Boolean)ret;
                }
                return true;
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Error adding property element:" + property, e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException("Error adding property element:" + property, e);
            }
        }
        return this.getListProperty(bean, property).add(value);
    }

    public void addPropertyElement(Object bean, String property, int index, Object value) {
        ContainerPropertyDescriptor desc = this.getContainerDescriptor(property);
        if (desc == null) {
            throw new RuntimeException("Property not found:" + property);
        }
        Method m = desc.getInsertMethod();
        if (m != null) {
            try {
                Class<?>[] types = m.getParameterTypes();
                Object[] parms = new Object[2];
                if (types[0].equals(Integer.TYPE)) {
                    parms[0] = new Integer(index);
                    parms[1] = value;
                } else {
                    parms[0] = value;
                    parms[1] = new Integer(index);
                }
                m.invoke(bean, parms);
                return;
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Error adding property element:" + property, e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException("Error adding property element:" + property, e);
            }
        }
        this.getListProperty(bean, property).add(index, value);
    }

    public Object setPropertyElement(Object bean, String property, int index, Object value) {
        ContainerPropertyDescriptor desc = this.getContainerDescriptor(property);
        if (desc == null) {
            throw new RuntimeException("Property not found:" + property);
        }
        Method m = desc.getReplaceIndexMethod();
        if (m != null) {
            try {
                Class<?>[] types = m.getParameterTypes();
                Object[] parms = new Object[2];
                if (types[0].equals(Integer.TYPE)) {
                    parms[0] = new Integer(index);
                    parms[1] = value;
                } else {
                    parms[0] = value;
                    parms[1] = new Integer(index);
                }
                return m.invoke(bean, parms);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Error replacing property element:" + property, e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException("Error replacing property element:" + property, e);
            }
        }
        return this.getListProperty(bean, property).set(index, value);
    }

    public boolean removePropertyElement(Object bean, String property, Object value) {
        ContainerPropertyDescriptor desc = this.getContainerDescriptor(property);
        if (desc == null) {
            throw new RuntimeException("Property not found:" + property);
        }
        Method m = desc.getRemoveMethod();
        if (m != null) {
            try {
                Object ret = m.invoke(bean, value);
                if (ret instanceof Boolean) {
                    return (Boolean)ret;
                }
                return true;
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Error removing property element:" + property, e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException("Error removing property element:" + property, e);
            }
        }
        return this.getListProperty(bean, property).remove(value);
    }

    public Object removePropertyElement(Object bean, String property, int index) {
        ContainerPropertyDescriptor desc = this.getContainerDescriptor(property);
        if (desc == null) {
            throw new RuntimeException("Property not found:" + property);
        }
        Method m = desc.getRemoveIndexedMethod();
        if (m != null) {
            try {
                Class<?>[] types = m.getParameterTypes();
                if (types[0].equals(Integer.TYPE)) {
                    Object[] parms = new Object[]{new Integer(index)};
                    return m.invoke(bean, parms);
                }
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Error removing property element:" + property, e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException("Error removing property element:" + property, e);
            }
        }
        return this.getListProperty(bean, property).remove(index);
    }

    public Object getPropertyElement(Object bean, String property, int index) {
        ContainerPropertyDescriptor desc = this.getContainerDescriptor(property);
        if (desc == null) {
            throw new RuntimeException("Property not found:" + property);
        }
        return this.getListProperty(bean, property).get(index);
    }

    public Set<String> getPropertyNames() {
        return Collections.unmodifiableSet(this.descriptors.keySet());
    }

    public PropertyDescriptor getDescriptor(String property) {
        return this.descriptors.get(property);
    }

    public ContainerPropertyDescriptor getContainerDescriptor(String property) {
        PropertyDescriptor obj = this.descriptors.get(property);
        if (obj == null) {
            return null;
        }
        if (obj instanceof ContainerPropertyDescriptor) {
            return (ContainerPropertyDescriptor)obj;
        }
        throw new RuntimeException("Property is not a list type:" + property);
    }

    public boolean addPropertyChangeListener(Object bean, PropertyChangeListener listener) {
        if (bean instanceof StandardBean) {
            ((StandardBean)bean).addPropertyChangeListener(listener);
            return true;
        }
        if (this.addListenerMethod != null) {
            try {
                this.addListenerMethod.invoke(bean, listener);
                return true;
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Error adding listener", e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException("Error adding listener", e);
            }
        }
        return false;
    }

    public void removePropertyChangeListener(Object bean, PropertyChangeListener listener) {
        if (bean instanceof StandardBean) {
            ((StandardBean)bean).removePropertyChangeListener(listener);
        } else if (this.removeListenerMethod != null) {
            try {
                this.removeListenerMethod.invoke(bean, listener);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Error removing listener", e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException("Error removing listener", e);
            }
        }
    }

    public static void main(String[] args) throws Exception {
        Log.initialize();
        log.setLogLevel(LogLevel.INFO);
        for (int i = 0; i < args.length; ++i) {
            Class<?> c = Class.forName(args[i]);
            BeanInspector beanInspector = BeanInspector.getInspector(c);
        }
    }
}

