/*
 * Decompiled with CFR 0.152.
 */
package org.progeeks.util.beans;

import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.progeeks.util.beans.BeanInspector;
import org.progeeks.util.log.Log;

public class ContainerPropertyDescriptor
extends PropertyDescriptor {
    static Log log = Log.getLog(ContainerPropertyDescriptor.class);
    private static final PluralPattern[] pluralPatterns = new PluralPattern[]{new PluralPattern("(.*)s", ""), new PluralPattern("(.*)ies", "y"), new PluralPattern("(.*)es", ""), new PluralPattern("(.*)i", "us"), new PluralPattern("(.*)ices", "ex"), new PluralPattern("(.*)es", "is")};
    private Class beanClass;
    private PropertyDescriptor desc;
    private Class elementClass;
    private boolean resizable;
    private boolean mutable;
    private boolean isArray;
    private boolean isList;
    private String singularName;
    private Method addMethod;
    private Method insertMethod;
    private Method setMethod;
    private Method removeMethod;
    private Method removeIndexedMethod;

    public ContainerPropertyDescriptor(Class beanClass, PropertyDescriptor desc) throws IntrospectionException {
        super(desc.getName(), (Method)BeanInspector.verifyAccess(desc.getReadMethod()), (Method)BeanInspector.verifyAccess(desc.getWriteMethod()));
        this.beanClass = beanClass;
        this.desc = desc;
        this.setBound(desc.isBound());
        this.setConstrained(desc.isConstrained());
        this.setupContainerInfo();
    }

    public static boolean isContainerType(Class type) {
        if (type == null) {
            return false;
        }
        if (type.isArray()) {
            return true;
        }
        return Collection.class.isAssignableFrom(type);
    }

    public static boolean isListType(Class type) {
        if (type == null) {
            return false;
        }
        if (type.isArray()) {
            return true;
        }
        return List.class.isAssignableFrom(type);
    }

    public boolean isList() {
        return this.isList;
    }

    public boolean isArray() {
        return this.isArray;
    }

    public boolean isResizable() {
        return this.resizable;
    }

    public boolean isMutable() {
        return this.mutable;
    }

    public Method getAddMethod() {
        return this.addMethod;
    }

    public Method getInsertMethod() {
        return this.insertMethod;
    }

    public Method getReplaceIndexMethod() {
        return this.setMethod;
    }

    public Method getRemoveMethod() {
        return this.removeMethod;
    }

    public Method getRemoveIndexedMethod() {
        return this.removeIndexedMethod;
    }

    public String getSingularPropertyName() {
        return this.singularName;
    }

    public Class getElementClass() {
        return this.elementClass;
    }

    protected boolean isSingularForm(String plural, String name) {
        boolean debug = log.isDebugEnabled();
        if (debug) {
            log.debug("isSingularForm(" + plural + ", " + name + ")");
        }
        if (name.length() == 0) {
            return false;
        }
        if (plural.charAt(0) != name.charAt(0)) {
            return false;
        }
        if (plural.length() > 1 && name.length() > 1 && plural.charAt(1) != name.charAt(1)) {
            return false;
        }
        for (int i = 0; i < pluralPatterns.length; ++i) {
            String s;
            if (debug) {
                log.debug("Checking:" + pluralPatterns[i]);
            }
            if ((s = pluralPatterns[i].convertToSingular(plural)) == null || !s.equals(name)) continue;
            if (debug) {
                log.debug(plural + " matches " + name);
            }
            return true;
        }
        return false;
    }

    protected void setupContainerInfo() {
        String capitalized;
        Class<?> type = this.desc.getPropertyType();
        this.isList = ContainerPropertyDescriptor.isListType(type);
        if (this.desc instanceof IndexedPropertyDescriptor) {
            this.elementClass = ((IndexedPropertyDescriptor)this.desc).getIndexedPropertyType();
            this.resizable = false;
            this.mutable = false;
            this.isArray = true;
            return;
        }
        if (type.isArray()) {
            this.elementClass = type.getComponentType();
            this.resizable = false;
            this.mutable = false;
            this.isArray = true;
            return;
        }
        this.resizable = true;
        if (List.class.isAssignableFrom(type)) {
            this.mutable = true;
        }
        if ((capitalized = this.desc.getName()).length() > 0) {
            capitalized = capitalized.substring(0, 1).toUpperCase() + capitalized.substring(1);
        }
        Class<?> found = null;
        int confidence = 0;
        Method[] methods = this.beanClass.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            int intVal;
            String propName;
            Class<?>[] types;
            String name = methods[i].getName();
            Class<?> candidate = null;
            if (name.startsWith("add")) {
                types = methods[i].getParameterTypes();
                if (types.length > 2 || !this.isSingularForm(capitalized, propName = name.substring(3))) continue;
                this.singularName = propName;
                if (types.length == 1) {
                    candidate = types[0];
                    this.addMethod = methods[i];
                } else if (types.length == 2) {
                    intVal = -1;
                    if (types[0].equals(Integer.TYPE)) {
                        intVal = 0;
                    } else if (types[1].equals(Integer.TYPE)) {
                        intVal = 1;
                    }
                    if (intVal == -1) continue;
                    candidate = types[intVal ^ 1];
                    this.insertMethod = methods[i];
                }
            } else if (name.startsWith("set")) {
                types = methods[i].getParameterTypes();
                if (types.length != 2 || !this.isSingularForm(capitalized, propName = name.substring(3))) continue;
                intVal = -1;
                if (types[0].equals(Integer.TYPE)) {
                    intVal = 0;
                } else if (types[1].equals(Integer.TYPE)) {
                    intVal = 1;
                }
                if (intVal == -1) continue;
                candidate = types[intVal ^ 1];
                this.setMethod = methods[i];
                this.singularName = propName;
            } else if (name.startsWith("remove")) {
                types = methods[i].getParameterTypes();
                if (types.length > 1 || !this.isSingularForm(capitalized, propName = name.substring(6))) continue;
                this.singularName = propName;
                if (types[0].equals(Integer.TYPE)) {
                    this.removeIndexedMethod = methods[i];
                    continue;
                }
                candidate = types[0];
                this.removeMethod = methods[i];
            } else if (name.startsWith("get")) {
                types = methods[i].getParameterTypes();
                if (types.length == 0 || types.length > 1 || !this.isSingularForm(capitalized, propName = name.substring(3))) continue;
                this.singularName = propName;
                if (!types[0].equals(Integer.TYPE)) continue;
                candidate = methods[i].getReturnType();
            }
            if (candidate == null) continue;
            if (found == null) {
                found = candidate;
                ++confidence;
                continue;
            }
            if (!found.equals(candidate)) continue;
            ++confidence;
        }
        this.addMethod = (Method)BeanInspector.verifyAccess(this.addMethod);
        this.insertMethod = (Method)BeanInspector.verifyAccess(this.insertMethod);
        this.setMethod = (Method)BeanInspector.verifyAccess(this.setMethod);
        this.removeMethod = (Method)BeanInspector.verifyAccess(this.removeMethod);
        this.removeIndexedMethod = (Method)BeanInspector.verifyAccess(this.removeIndexedMethod);
        this.elementClass = found;
        if (found != null && confidence < 2) {
            log.info("Found:" + this.elementClass + "  based on only one piece of evidence.");
        } else {
            log.debug("Found:" + this.elementClass + "  with a confidence factor of:" + confidence);
        }
    }

    protected static class PluralPattern {
        private Pattern pattern;
        private String suffix;

        public PluralPattern(String pattern, String suffix) {
            this.suffix = suffix;
            this.pattern = Pattern.compile(pattern);
        }

        public String convertToSingular(String name) {
            Matcher m = this.pattern.matcher(name);
            if (!m.matches()) {
                return null;
            }
            return m.group(1) + this.suffix;
        }

        public String toString() {
            return "PluralPattern[" + this.pattern.pattern() + ", " + this.suffix + "]";
        }
    }
}

