/*
 * Decompiled with CFR 0.152.
 */
package org.progeeks.util.beans;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.progeeks.util.Inspector;

public class PropertyChangeLink
implements PropertyChangeListener {
    private Inspector ins;
    private String sourceProperty;
    private String targetProperty;

    public PropertyChangeLink() {
    }

    public PropertyChangeLink(Object delegateBean) {
        this.setDelegate(delegateBean);
    }

    public PropertyChangeLink(String source, String target, Object delegate) {
        this.sourceProperty = source;
        this.targetProperty = target;
        this.setDelegate(delegate);
    }

    public void initializeProperty(Object sourceBean) {
        Inspector source = new Inspector(sourceBean);
        String sourceName = this.getSourceProperty();
        String targetName = this.getTargetProperty();
        this.ins.set(targetName, source.get(sourceName));
    }

    public void setDelegate(Object delegateBean) {
        this.ins = new Inspector(delegateBean);
    }

    public Object getDelegate() {
        return this.ins != null ? this.ins.getObject() : null;
    }

    public void setSourceProperty(String name) {
        this.sourceProperty = name;
    }

    public String getSourceProperty() {
        if (this.sourceProperty == null) {
            return this.targetProperty;
        }
        return this.sourceProperty;
    }

    public void setTargetProperty(String name) {
        this.targetProperty = name;
    }

    public String getTargetProperty() {
        if (this.targetProperty == null) {
            return this.sourceProperty;
        }
        return this.targetProperty;
    }

    public void propertyChange(PropertyChangeEvent event) {
        String name = event.getPropertyName();
        String source = this.getSourceProperty();
        String target = this.getTargetProperty();
        if (source == null) {
            this.ins.set(name, event.getNewValue());
            return;
        }
        if (!source.equals(name)) {
            return;
        }
        this.ins.set(target, event.getNewValue());
    }
}

