/*
 * Decompiled with CFR 0.152.
 */
package org.progeeks.util.beans;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.progeeks.util.beans.BeanChangeSupport;

public class PropertyHolder
extends BeanChangeSupport
implements Serializable {
    static final long serialVersionUID = 1L;
    private Map<String, Object> properties = new HashMap<String, Object>();
    private BeanChangeSupport delegate;

    public PropertyHolder() {
    }

    public PropertyHolder(BeanChangeSupport delegate) {
        this.delegate = delegate;
    }

    public boolean setObjectProperty(String property, Object obj) {
        Object oldVal = this.properties.get(property);
        if (oldVal == obj) {
            return false;
        }
        if (oldVal != null && oldVal.equals(obj)) {
            return false;
        }
        this.properties.put(property, obj);
        this.firePropertyChange(property, oldVal, obj);
        if (this.delegate != null) {
            this.delegate.firePropertyChange(property, oldVal, obj);
        }
        return true;
    }

    public Object getObjectProperty(String property) {
        return this.properties.get(property);
    }

    public Object getObjectProperty(String property, Object defaultValue) {
        if (this.properties.containsKey(property)) {
            return this.properties.get(property);
        }
        return defaultValue;
    }

    public boolean setStringProperty(String property, String value) {
        return this.setObjectProperty(property, value);
    }

    public String getStringProperty(String property, String defaultValue) {
        if (!this.properties.containsKey(property)) {
            return defaultValue;
        }
        return (String)this.getObjectProperty(property);
    }

    public boolean setIntProperty(String property, int i) {
        return this.setObjectProperty(property, new Integer(i));
    }

    public int getIntProperty(String property, int defaultValue) {
        Integer i = (Integer)this.getObjectProperty(property);
        if (i == null) {
            return defaultValue;
        }
        return i;
    }

    public boolean setLongProperty(String property, long l) {
        return this.setObjectProperty(property, new Long(l));
    }

    public long getLongProperty(String property, long defaultValue) {
        Long l = (Long)this.getObjectProperty(property);
        if (l == null) {
            return defaultValue;
        }
        return l;
    }

    public boolean setDoubleProperty(String property, double d) {
        return this.setObjectProperty(property, new Double(d));
    }

    public double getDoubleProperty(String property, double defaultValue) {
        Double d = (Double)this.getObjectProperty(property);
        if (d == null) {
            return defaultValue;
        }
        return d;
    }

    public boolean setFloatProperty(String property, float d) {
        return this.setObjectProperty(property, new Float(d));
    }

    public float getFloatProperty(String property, float defaultValue) {
        Float d = (Float)this.getObjectProperty(property);
        if (d == null) {
            return defaultValue;
        }
        return d.floatValue();
    }

    public boolean setBooleanProperty(String property, boolean b) {
        return this.setObjectProperty(property, b);
    }

    public boolean getBooleanProperty(String property, boolean defaultValue) {
        Boolean b = (Boolean)this.getObjectProperty(property);
        if (b == null) {
            return defaultValue;
        }
        return b;
    }
}

