/*
 * Decompiled with CFR 0.152.
 */
package org.progeeks.util.beans;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;

public class RecordingPropertyChangeListener
implements PropertyChangeListener {
    public static final int UNLIMITTED_EVENTS = -1;
    protected int maxEvents = -1;
    protected List events = new ArrayList();

    public RecordingPropertyChangeListener(int maxEvents) {
        this.setMaxEvents(maxEvents);
    }

    public RecordingPropertyChangeListener() {
        this(-1);
    }

    public synchronized void setMaxEvents(int maxEvents) {
        this.maxEvents = maxEvents;
        this.truncateEvents();
    }

    public synchronized void propertyChange(PropertyChangeEvent event) {
        this.events.add(event);
        this.truncateEvents();
    }

    public synchronized boolean hasEvents() {
        return !this.events.isEmpty();
    }

    public synchronized int eventCount() {
        return this.events.size();
    }

    public synchronized void clear() {
        this.events.clear();
    }

    public synchronized PropertyChangeEvent getLastEvent() {
        return this.getLastEvent(true);
    }

    public synchronized PropertyChangeEvent getLastEvent(boolean clear) {
        if (this.events.size() == 0) {
            return null;
        }
        PropertyChangeEvent lastEvent = (PropertyChangeEvent)this.events.get(this.events.size() - 1);
        if (clear) {
            this.events.clear();
        }
        return lastEvent;
    }

    public synchronized List getEvents() {
        return this.getEvents(true);
    }

    public synchronized List getEvents(boolean clear) {
        ArrayList results = new ArrayList(this.events);
        if (clear) {
            this.events.clear();
        }
        return results;
    }

    protected synchronized void truncateEvents() {
        if (this.maxEvents <= 0) {
            return;
        }
        while (this.events.size() > this.maxEvents) {
            this.events.remove(0);
        }
    }
}

