/*
 * Decompiled with CFR 0.152.
 */
package org.progeeks.util.beans;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.progeeks.util.beans.BeanConfigurator;
import org.progeeks.util.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SingletonConfigurator<V>
extends BeanConfigurator<V> {
    static final long serialVersionUID = 1L;
    static Log log = Log.getLog(SingletonConfigurator.class);
    private Map<Object, V> singletonMap = new HashMap<Object, V>();

    public SingletonConfigurator() {
    }

    public SingletonConfigurator(Class beanClass) {
        super(beanClass);
    }

    @Override
    public V createObject(Map objects, Object ... args) {
        V result;
        ArrayList<Object> key = null;
        if (args != null) {
            key = args.length == 1 ? args[0] : new ArrayList<Object>(Arrays.asList(args));
            if (log.isDebugEnabled()) {
                log.debug("singleton key:" + key);
            }
        }
        if ((result = this.singletonMap.get(key)) != null) {
            if (log.isDebugEnabled()) {
                log.debug("Reusing previosly created instance:" + result);
            }
            return result;
        }
        result = super.createObject(objects, args);
        this.singletonMap.put(key, result);
        return result;
    }

    @Override
    public String toString() {
        return "SingletonConfigurator[ beanClass=" + this.getBeanClass() + ", properties=" + super.toString() + " ]";
    }
}

