/*
 * Decompiled with CFR 0.152.
 */
package org.progeeks.util.el;

import java.security.GeneralSecurityException;
import java.security.Provider;
import java.security.Security;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.progeeks.util.StringUtils;
import org.progeeks.util.el.AbstractTransformingAccess;
import org.progeeks.util.el.PatternedTransformingAccess;
import org.progeeks.util.log.Log;

public class CipherTransform
extends AbstractTransformingAccess
implements PatternedTransformingAccess {
    static Log log = Log.getLog();
    public static final String PATTERN = ".(encrypt|decrypt)\\((.*)\\)";
    private static Pattern format = Pattern.compile(".(encrypt|decrypt)\\((.*)\\)");
    private static final byte[] DEFAULT_KEY = new byte[]{-124, 33, 25, -70, -36, -91, -96, 42, -33, -18, 106, 36, 21, 81, 105, 85, 69, 77, 126, 8, -128, 104, 63, 75, -66, 79, -39, -2, -104, 85, 98, 83, -18, -14, -126, -51, -96, 31, 73, 58, 12, -80, -28, 98, -94, -20, 38, 99, -29, -93, 11, -39, -42, 12, -34, -46, -127, 106, 70, -77, -36, 89, 43, -46, -104, 69, 123, 111, 76, 5, -71, 56, -70, 60, -96, 55, -127, 78, 117, 89, -17, 55, 50, 64, -93, -111, 104, 42, 80, 80, -100, 23, 83, -74, -61, 62, -90, -40, -27, 8, -121, 3, 7, -125, 57, -45, 30, 60, 109, -74, 108, -16, 76, -41, 86, 86, 109, 9, -23, -108, -11, -91, 33, -103, -111, 109, -123, -84};
    private byte[] keyBytes;

    public CipherTransform() {
        this(DEFAULT_KEY);
    }

    public CipherTransform(byte[] keyBytes) {
        this.keyBytes = keyBytes;
    }

    public void setKeyBytes(byte[] keyBytes) {
        this.keyBytes = keyBytes;
    }

    public byte[] getKeyBytes() {
        return this.keyBytes;
    }

    public String getPattern() {
        return PATTERN;
    }

    protected String transform(boolean encrypt, String value, String algorithm) {
        if (log.isTraceEnabled()) {
            log.trace("transform(" + encrypt + ", " + value + ", " + algorithm + ")");
        }
        try {
            String padding = "NoPadding";
            String transformation = algorithm + "/ECB/" + padding;
            int keyLength = Cipher.getMaxAllowedKeyLength(transformation);
            int size = keyLength / 8;
            size = Math.min(this.keyBytes.length, size);
            Cipher cipher = Cipher.getInstance(transformation);
            SecretKeySpec key = new SecretKeySpec(this.keyBytes, 0, size, algorithm);
            if (encrypt) {
                int blockSize = cipher.getBlockSize();
                if (value.length() % blockSize != 0) {
                    int diff = blockSize - value.length() % blockSize;
                    value = StringUtils.pad(value, value.length() + diff);
                }
                byte[] input = value.getBytes();
                byte[] result = new byte[input.length];
                cipher.init(1, key);
                int len = cipher.update(input, 0, input.length, result, 0);
                if (len == input.length) {
                    cipher.doFinal();
                } else {
                    len += cipher.doFinal(result, len);
                }
                return StringUtils.toHexEncoding(result);
            }
            byte[] input = StringUtils.fromHexEncoding(value);
            byte[] result = new byte[input.length];
            cipher.init(2, key);
            int len = cipher.update(input, 0, input.length, result, 0);
            if (len == input.length) {
                cipher.doFinal();
            } else {
                len += cipher.doFinal(result, len);
            }
            return new String(result).trim();
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException("Could not transform cipher text with algorithm:" + algorithm, e);
        }
    }

    public Object getProperty(Object object, String property) {
        boolean encrypt;
        Matcher m = format.matcher(property);
        if (!m.matches()) {
            throw new IllegalArgumentException("Could not parse format argument[" + property + "]");
        }
        String type = m.group(1);
        if (type == null) {
            throw new IllegalArgumentException("Expected encrypt or dectype and got null.");
        }
        if ("encrypt".equals(type)) {
            encrypt = true;
        } else if ("decrypt".equals(type)) {
            encrypt = false;
        } else {
            throw new IllegalArgumentException("Unknown transform type:" + type);
        }
        String args = m.group(2);
        if (args == null || args.trim().length() == 0) {
            throw new IllegalArgumentException("Format argument cannot be empty[" + property + "]");
        }
        int split = args.lastIndexOf(44);
        if (split < 0) {
            return this.transform(encrypt, String.valueOf(object), args.trim());
        }
        String alg = args.substring(split + 1).trim();
        String value = args.substring(0, split).trim();
        if (value.charAt(0) == '\"' && value.charAt(value.length() - 1) == '\"') {
            value = value.substring(1, value.length() - 1);
        } else if (value.charAt(0) == '\'' && value.charAt(value.length() - 1) == '\'') {
            value = value.substring(1, value.length() - 1);
        }
        return this.transform(encrypt, value, alg);
    }

    public Class getPropertyClass(Object object, String property) {
        return String.class;
    }

    public Object getPropertyType(Object type, String property) {
        return String.class;
    }

    private static void printRandomKey() {
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 8; ++j) {
                int val = (int)(256.0 * Math.random());
                System.out.print("0x" + Integer.toHexString(val));
                System.out.print(", ");
            }
            System.out.println();
        }
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            System.out.println("Usage: CipherTransform - | <Algorithm> | <expression>");
            System.out.println("Where:");
            System.out.println("  - - will list all providers.");
            System.out.println("  <algorithm> - is an algorithm or type used to search");
            System.out.println("            for specific providers.");
            System.out.println("  <expression> - a properly formatted expression passed to");
            System.out.println("            this transformer for processing.  For example:");
            System.out.println("           \"%encrypt( 'Testing', AES )\"");
            System.out.println("           \"%encrypt( Testing, AES )\"");
            return;
        }
        if (args[0].equals("-")) {
            System.out.println("Security providers:");
            Provider[] providers = Security.getProviders();
            for (int i = 0; i < providers.length; ++i) {
                System.out.println("[" + i + "] = " + providers[i]);
                System.out.println("  " + StringUtils.join(providers[i].getServices(), "\n  "));
            }
            return;
        }
        if (args[0].startsWith("%")) {
            CipherTransform xform = new CipherTransform();
            Object result = xform.getProperty("test", args[0]);
            System.out.println(args[0] + " = [" + result + "]");
        } else {
            String a = args[0];
            System.out.println("Cipher providers for:" + a);
            Provider[] array = Security.getProviders("Cipher." + a);
            System.out.println("    " + StringUtils.join(Arrays.asList(array), "\n    "));
        }
    }
}

