/*
 * Decompiled with CFR 0.152.
 */
package org.progeeks.util.el;

import java.util.ArrayList;
import java.util.Collection;
import org.progeeks.util.AbstractPropertyAccess;
import org.progeeks.util.PropertyAccess;
import org.progeeks.util.el.PropertyAccessRootAware;

public class CollectionExpanderAccess
extends AbstractPropertyAccess
implements PropertyAccessRootAware {
    private PropertyAccess rootAccess;
    private boolean allNullsIsEmpty = false;

    public void setRootAccess(PropertyAccess access) {
        this.rootAccess = access;
    }

    public Object getProperty(Object object, String property) {
        Collection c = (Collection)object;
        ArrayList<Object> result = new ArrayList<Object>();
        int nonNull = 0;
        for (Object o : c) {
            if (o != null) {
                Object value = this.rootAccess.getProperty(o, property);
                if (value != null) {
                    ++nonNull;
                }
                result.add(value);
                continue;
            }
            result.add(null);
        }
        if (result.size() == 0 || nonNull == 0 && this.allNullsIsEmpty) {
            return null;
        }
        if (result.size() == 1) {
            return result.get(0);
        }
        return result;
    }

    public boolean hasProperty(Object object, String property) {
        Collection c = (Collection)object;
        for (Object o : c) {
            if (o == null || !this.rootAccess.hasProperty(o, property)) continue;
            return true;
        }
        return false;
    }

    public boolean hasMutableProperty(Object object, String property) {
        Collection c = (Collection)object;
        for (Object o : c) {
            if (o == null || !this.rootAccess.hasMutableProperty(o, property)) continue;
            return true;
        }
        return false;
    }

    public void setProperty(Object object, String property, Object value) {
        Collection c = (Collection)object;
        for (Object o : c) {
            if (o == null) continue;
            this.rootAccess.setProperty(o, property, value);
        }
    }

    public Class getPropertyClass(Object object, String property) {
        Collection c = (Collection)object;
        for (Object o : c) {
            Class type;
            if (o == null || (type = this.rootAccess.getPropertyClass(o, property)) == null) continue;
            return type;
        }
        return null;
    }
}

