/*
 * Decompiled with CFR 0.152.
 */
package org.progeeks.util.el;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.progeeks.util.el.AbstractTransformingAccess;
import org.progeeks.util.el.PatternedTransformingAccess;

public class EachTransform
extends AbstractTransformingAccess
implements PatternedTransformingAccess {
    public static final String PATTERN = ".each\\((.*)\\)";
    private static Pattern argPattern = Pattern.compile(".each\\((.*)\\)");

    public String getPattern() {
        return PATTERN;
    }

    protected Object getValue(Object o, String property) {
        if (property == null) {
            return o;
        }
        if (!this.getRootAccess().hasProperty(o, property)) {
            return null;
        }
        return this.getRootAccess().getProperty(o, property);
    }

    public Object getProperty(Object object, String property) {
        if (object == null) {
            return null;
        }
        Matcher m = argPattern.matcher(property);
        if (!m.matches()) {
            throw new IllegalArgumentException("Could not parse property argument from[" + property + "]");
        }
        String s = m.group(1).trim();
        if (s.length() == 0) {
            s = null;
        }
        if (!(object instanceof Collection)) {
            return this.getValue(object, s);
        }
        ArrayList<Object> results = new ArrayList<Object>();
        Iterator i = ((Collection)object).iterator();
        while (i.hasNext()) {
            results.add(this.getValue(i.next(), s));
        }
        return results;
    }
}

