/*
 * Decompiled with CFR 0.152.
 */
package org.progeeks.util.el;

import java.util.Formatter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.progeeks.util.el.AbstractTransformingAccess;
import org.progeeks.util.el.PatternedTransformingAccess;

public class FormatTransform
extends AbstractTransformingAccess
implements PatternedTransformingAccess {
    public static final String PATTERN = ".format\\((.*)\\)";
    private static Pattern format = Pattern.compile(".format\\((.*)\\)");

    public String getPattern() {
        return PATTERN;
    }

    public Object getProperty(Object object, String property) {
        Matcher m = format.matcher(property);
        if (!m.matches()) {
            throw new IllegalArgumentException("Could not parse format argument[" + property + "]");
        }
        String f = m.group(1);
        if (f == null || f.trim().length() == 0) {
            throw new IllegalArgumentException("Format argument cannot be empty[" + property + "]");
        }
        Formatter formatter = new Formatter();
        formatter.format(f, object);
        return formatter.toString();
    }

    public Class getPropertyClass(Object object, String property) {
        return String.class;
    }

    public Object getPropertyType(Object type, String property) {
        return String.class;
    }
}

