/*
 * Decompiled with CFR 0.152.
 */
package org.progeeks.util.el;

import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.progeeks.util.el.AbstractTransformingAccess;
import org.progeeks.util.el.PatternedTransformingAccess;

public class JoinTransform
extends AbstractTransformingAccess
implements PatternedTransformingAccess {
    public static final String PATTERN = ".join\\((.*)\\)";
    private static Pattern argPattern = Pattern.compile(".join\\((.*)\\)");

    public String getPattern() {
        return PATTERN;
    }

    public Object getProperty(Object object, String property) {
        if (object == null) {
            return null;
        }
        Matcher m = argPattern.matcher(property);
        if (!m.matches()) {
            throw new IllegalArgumentException("Could not parse property argument from[" + property + "]");
        }
        String s = m.group(1).trim();
        if (s.length() == 0) {
            s = ",";
        }
        if (!(object instanceof Collection)) {
            return object;
        }
        StringBuilder sb = new StringBuilder();
        for (Object o : (Collection)object) {
            if (sb.length() > 0) {
                sb.append(s);
            }
            sb.append(this.convertToString(o));
        }
        return sb;
    }

    protected String convertToString(Object o) {
        return String.valueOf(o);
    }
}

