/*
 * Decompiled with CFR 0.152.
 */
package org.progeeks.util.el;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.progeeks.util.ObjectUtils;
import org.progeeks.util.SimpleExpressionLanguage;
import org.progeeks.util.beans.BeanPropertyAdapter;
import org.progeeks.util.el.CollectionExpanderAccess;
import org.progeeks.util.el.DefaultAccessStack;
import org.progeeks.util.log.Log;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class XmlPropertyAccess
extends BeanPropertyAdapter {
    static Log log = Log.getLog();
    private static final Pattern ARGS = Pattern.compile("([^()]+?)(?::?\\((.*)\\))?|(?:\\((.*)\\)):?([^()]+)");

    protected String[] getSplitName(Node n) {
        String[] result = new String[2];
        String name = n.getNodeName();
        result[0] = n.getPrefix();
        result[1] = n.getLocalName();
        if (result[1] != null) {
            return result;
        }
        return this.getSplitName(name, result);
    }

    protected String[] getSplitName(String name, String[] result) {
        int split;
        if (result == null) {
            result = new String[2];
        }
        if ((split = name.lastIndexOf(58)) < 0) {
            result[1] = name;
            return result;
        }
        result[0] = name.substring(0, split);
        result[1] = name.substring(split + 1);
        return result;
    }

    protected boolean nodeMatches(String prefix, String uri, String name, Node node) {
        if (log.isTraceEnabled()) {
            log.trace("nodeMatches(" + prefix + ", " + uri + ", " + name + ", " + node + ")");
        }
        String nodeName = node.getNodeName();
        if (prefix == null && uri == null && name.equals(nodeName)) {
            return true;
        }
        String[] splitName = this.getSplitName(node);
        if (uri == null) {
            return name.equals(splitName[1]);
        }
        if (splitName[0] == null) {
            if (uri != null && uri.length() > 0) {
                return false;
            }
            return name.equals(splitName[1]);
        }
        String localPrefix = this.lookupPrefix(node, uri, false);
        if (localPrefix != null) {
            prefix = localPrefix;
        }
        if (prefix == null) {
            log.warn("Prefix not found for URI:" + uri);
        }
        if (!ObjectUtils.areEqual(prefix, splitName[0])) {
            return false;
        }
        return ObjectUtils.areEqual(name, splitName[1]);
    }

    protected String lookupPrefix(Node node, String uri, boolean checkParents) {
        if (uri == null) {
            return null;
        }
        if (uri.length() == 0) {
            return "";
        }
        NamedNodeMap attrs = node.getAttributes();
        if (attrs == null) {
            return null;
        }
        for (int i = 0; i < attrs.getLength(); ++i) {
            String value;
            String name = attrs.item(i).getNodeName();
            if (!name.startsWith("xmlns:") || !(value = attrs.item(i).getNodeValue()).equalsIgnoreCase(uri)) continue;
            String prefix = name.substring("xmlns:".length());
            return prefix;
        }
        if (checkParents && node.getParentNode() != null) {
            return this.lookupPrefix(node.getParentNode(), uri, true);
        }
        return null;
    }

    protected Node getAttribute(String prefix, String uri, String name, Node node) {
        NamedNodeMap attrs = node.getAttributes();
        if (attrs.getLength() == 0) {
            return null;
        }
        for (int i = 0; i < attrs.getLength(); ++i) {
            Node child = attrs.item(i);
            if (!this.nodeMatches(prefix, uri, name, child)) continue;
            return child;
        }
        return null;
    }

    protected Object getChildNodes(Node parent, String property) {
        String[] search;
        if (parent instanceof Document) {
            parent = ((Document)parent).getDocumentElement();
        }
        if (property == null) {
            return null;
        }
        if (property.length() == 0) {
            return null;
        }
        String uri = null;
        int split = property.indexOf(40);
        if (split >= 0) {
            Matcher m = ARGS.matcher(property);
            if (m.matches()) {
                if (m.group(1) != null) {
                    property = m.group(1);
                    uri = m.group(2);
                } else {
                    uri = m.group(3);
                    property = m.group(4);
                }
            } else {
                throw new IllegalArgumentException("Invalid (URI) property form:" + property + " for XML lookup.");
            }
        }
        if ((search = this.getSplitName(property, null))[0] != null) {
            throw new UnsupportedOperationException("Prefix based URI lookups are not implemented.");
        }
        if (search[1].length() == 0) {
            return null;
        }
        String prefix = this.lookupPrefix(parent, uri, true);
        ArrayList<Node> results = null;
        if (search[1].charAt(0) == '@') {
            return this.getAttribute(prefix, uri, search[1].substring(1), parent);
        }
        NodeList l = parent.getChildNodes();
        if (l == null) {
            return null;
        }
        for (int i = 0; i < l.getLength(); ++i) {
            Node child = l.item(i);
            if (!this.nodeMatches(prefix, uri, search[1], child)) continue;
            if (results == null) {
                results = new ArrayList<Node>();
            }
            if (log.isTraceEnabled()) {
                log.trace("Adding:" + child);
            }
            results.add(child);
        }
        if (results == null) {
            return null;
        }
        if (results.size() == 1) {
            return results.get(0);
        }
        return results;
    }

    public Object getProperty(Object object, String property) {
        Object result;
        if (log.isTraceEnabled()) {
            log.trace("getProperty(" + object + ", " + property + ")");
        }
        if ((result = this.getChildNodes((Node)object, property)) != null) {
            return result;
        }
        return super.getProperty(object, property);
    }

    public boolean hasProperty(Object object, String property) {
        if (log.isTraceEnabled()) {
            log.trace("hasProperty(" + object + ", " + property + ")");
        }
        if (this.getChildNodes((Node)object, property) != null) {
            return true;
        }
        return super.hasProperty(object, property);
    }

    public boolean hasMutableProperty(Object object, String property) {
        if (log.isTraceEnabled()) {
            log.trace("hasMutableProperty(" + object + ", " + property + ")");
        }
        return super.hasMutableProperty(object, property);
    }

    public void setProperty(Object object, String property, Object value) {
        if (log.isTraceEnabled()) {
            log.trace("setProperty(" + object + ", " + property + ", " + value + ")");
        }
        super.setProperty(object, property, value);
    }

    public Class getPropertyClass(Object object, String property) {
        Object o;
        if (log.isTraceEnabled()) {
            log.trace("getPropertyClass(" + object + ", " + property + ")");
        }
        if ((o = this.getChildNodes((Node)object, property)) != null) {
            return o.getClass();
        }
        return super.getPropertyClass(object, property);
    }

    public static void print(Object o) {
        if (o instanceof Collection) {
            Iterator i = ((Collection)o).iterator();
            while (i.hasNext()) {
                XmlPropertyAccess.print(i.next());
            }
        } else if (o instanceof Node) {
            Node n = (Node)o;
            System.out.println(n);
            System.out.println("  hasChildren:" + n.hasChildNodes());
            System.out.println("  value:" + n.getNodeValue());
            System.out.println("  text:" + n.getTextContent());
            NodeList l = n.getChildNodes();
            if (l != null) {
                System.out.println("  children:");
                for (int i = 0; i < l.getLength(); ++i) {
                    Node child = l.item(i);
                    System.out.println("    " + child);
                }
            }
        } else {
            System.out.println(o);
        }
    }

    public static void main(String[] args) throws Exception {
        Log.initialize();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder parser = factory.newDocumentBuilder();
        Document doc = parser.parse(new InputSource(System.in));
        System.out.println("doc:" + doc);
        DefaultAccessStack access = new DefaultAccessStack();
        access.registerType(Node.class, new XmlPropertyAccess());
        access.registerType(Collection.class, new CollectionExpanderAccess());
        SimpleExpressionLanguage el = new SimpleExpressionLanguage(access);
        for (String s : args) {
            Object o = el.getProperty((Object)doc, s);
            System.out.println(s + " = " + o);
        }
    }
}

