/*
 * Decompiled with CFR 0.152.
 */
package org.progeeks.util.log;

import org.apache.log4j.spi.LoggingEvent;
import org.progeeks.util.log.LogLevel;

public class LogEvent {
    private LoggingEvent event;

    public LogEvent(LoggingEvent event) {
        this.event = event;
    }

    public String getLogName() {
        return this.event.getLoggerName();
    }

    public LogLevel getLogLevel() {
        return LogLevel.toLevel(this.event.getLevel().toInt());
    }

    public String getContext() {
        return this.event.getNDC();
    }

    public String getMessage() {
        return String.valueOf(this.event.getMessage());
    }

    public String getThreadName() {
        return this.event.getThreadName();
    }

    public Throwable getThrowable() {
        if (this.event.getThrowableInformation() == null) {
            return null;
        }
        return this.event.getThrowableInformation().getThrowable();
    }

    public long getTime() {
        return this.event.timeStamp;
    }

    public String toString() {
        return "LogEvent[" + this.getLogName() + ", " + this.getLogLevel() + ", " + this.getMessage() + "]";
    }
}

