/*
 * Decompiled with CFR 0.152.
 */
package org.progeeks.util.log;

import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.progeeks.util.log.LegacyTraceLevel;

public class LogLevel {
    public static final LogLevel ALL = new LogLevel(Level.ALL);
    public static final LogLevel TRACE = new LogLevel(LegacyTraceLevel.TRACE);
    public static final LogLevel DEBUG = new LogLevel(Level.DEBUG);
    public static final LogLevel ERROR = new LogLevel(Level.ERROR);
    public static final LogLevel FATAL = new LogLevel(Level.FATAL);
    public static final LogLevel INFO = new LogLevel(Level.INFO);
    public static final LogLevel OFF = new LogLevel(Level.OFF);
    public static final LogLevel WARN = new LogLevel(Level.WARN);
    public static final int ALL_INT = Integer.MIN_VALUE;
    public static final int TRACE_INT = 5000;
    public static final int DEBUG_INT = 10000;
    public static final int ERROR_INT = 40000;
    public static final int FATAL_INT = 50000;
    public static final int INFO_INT = 20000;
    public static final int OFF_INT = Integer.MAX_VALUE;
    public static final int WARN_INT = 30000;
    private Level level;

    private LogLevel(Level level) {
        this.level = level;
    }

    public int toInt() {
        return this.level.toInt();
    }

    public boolean isGreaterOrEqual(LogLevel l) {
        return this.level.isGreaterOrEqual((Priority)l.level);
    }

    public static LogLevel toLevel(int val) {
        switch (val) {
            case -2147483648: {
                return ALL;
            }
            case 10000: {
                return DEBUG;
            }
            case 40000: {
                return ERROR;
            }
            case 50000: {
                return FATAL;
            }
            case 20000: {
                return INFO;
            }
            case 5000: {
                return TRACE;
            }
            case 0x7FFFFFFF: {
                return OFF;
            }
            case 30000: {
                return WARN;
            }
        }
        throw new IllegalArgumentException("Unknown value:" + val);
    }

    public static LogLevel toLevel(String s) {
        Level lvl = LegacyTraceLevel.toLevel(s);
        return LogLevel.toLevel(lvl.toInt());
    }

    public String toString() {
        return this.level.toString();
    }
}

