/*
 * Decompiled with CFR 0.152.
 */
package org.progeeks.util.swing;

import java.awt.event.ActionEvent;
import java.lang.reflect.Method;
import javax.swing.AbstractAction;

public class ActionDelegateAdapter
extends AbstractAction {
    static final long serialVersionUID = 1L;
    private static final Class[] ARG_TYPES = new Class[]{ActionEvent.class};
    private Method method;
    private boolean takesEvent;
    private Object delegate;

    public ActionDelegateAdapter(String name, Object delegate, String methodName) {
        super(name);
        if (delegate == null) {
            throw new IllegalArgumentException("Delegate cannot be null.");
        }
        if (methodName == null) {
            throw new IllegalArgumentException("Method name cannot be null.");
        }
        this.delegate = delegate;
        Class<?> c = delegate.getClass();
        this.takesEvent = true;
        this.method = ActionDelegateAdapter.getMethod(c, methodName, ARG_TYPES, true);
        if (this.method == null) {
            this.method = ActionDelegateAdapter.getMethod(c, methodName, null, true);
            this.takesEvent = false;
        }
        if (this.method == null) {
            throw new IllegalArgumentException("Method:" + methodName + " not found in delegate class:" + c);
        }
    }

    public void actionPerformed(ActionEvent event) {
        try {
            if (this.takesEvent) {
                this.method.invoke(this.delegate, event);
            } else {
                this.method.invoke(this.delegate, (Object[])null);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error delegating event delivery", e);
        }
    }

    private static Method getMethod(Class type, String methodName, Class[] argTypes, boolean publicOnly) {
        try {
            if (publicOnly) {
                return type.getMethod(methodName, argTypes);
            }
            return type.getDeclaredMethod(methodName, argTypes);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }
}

