/*
 * Decompiled with CFR 0.152.
 */
package org.progeeks.util.swing;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Action;
import javax.swing.Icon;
import org.progeeks.util.DefaultObservableList;
import org.progeeks.util.ObjectUtils;
import org.progeeks.util.ViewContext;
import org.progeeks.util.ViewContextAware;
import org.progeeks.util.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionList
extends DefaultObservableList<Object>
implements Action,
ViewContextAware,
Cloneable {
    static final long serialVersionUID = 1L;
    static Log log = Log.getLog(ActionList.class);
    private HashMap<String, Object> properties = new HashMap();
    private ViewContext context;
    private boolean enabled = true;
    private boolean deepClone = true;

    public ActionList() {
        super(new ArrayList());
    }

    public ActionList(String name) {
        this();
        this.properties.put("Name", name);
    }

    public ActionList(String name, Icon icon) {
        this();
        this.properties.put("Name", name);
        this.properties.put("SmallIcon", icon);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        ActionList l = (ActionList)obj;
        if (!this.properties.equals(l.properties)) {
            return false;
        }
        if (this.context != null && !this.context.equals(l.context)) {
            return false;
        }
        return super.equals(obj);
    }

    @Override
    public int hashCode() {
        int hash = this.properties.hashCode() + super.hashCode();
        return hash;
    }

    @Override
    public void setViewContext(ViewContext context) {
        this.context = context;
        for (Object obj : this) {
            if (!(obj instanceof ViewContextAware)) continue;
            ((ViewContextAware)obj).setViewContext(context);
        }
    }

    @Override
    public ViewContext getViewContext() {
        return this.context;
    }

    public void setDeepClone(boolean flag) {
        this.deepClone = flag;
    }

    public boolean getDeepClone() {
        return this.deepClone;
    }

    protected void initializeClone(ActionList clone) {
    }

    protected void preinitializeClone(ActionList clone) {
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        if (this.getDeepClone()) {
            return this.deepClone(new HashMap<Object, Object>());
        }
        ActionList clone = (ActionList)super.clone();
        this.preinitializeClone(clone);
        this.initializeClone(clone);
        return clone;
    }

    protected Object deepClone(Map<Object, Object> references) throws CloneNotSupportedException {
        ActionList clone = (ActionList)super.clone();
        this.preinitializeClone(clone);
        references.put(this, clone);
        if (!this.getDeepClone()) {
            this.initializeClone(clone);
            return clone;
        }
        for (int i = 0; i < this.size(); ++i) {
            Object o = clone.get(i);
            Object reference = references.get(o);
            if (reference != null) {
                clone.set(i, reference);
                continue;
            }
            if (o instanceof ActionList) {
                reference = ((ActionList)o).deepClone(references);
            } else {
                reference = ObjectUtils.cloneObject(o);
                if (reference == o) {
                    if (!(o instanceof ViewContextAware)) continue;
                    log.warn("Object is not cloneable but is context aware:" + o + " This is usually a mistake.");
                    continue;
                }
            }
            Object old = clone.set(i, reference);
            references.put(o, reference);
        }
        this.initializeClone(clone);
        return clone;
    }

    public Action getAction(String name) {
        String alternate = name + "...";
        for (Action a : this) {
            if (a == null) continue;
            if (a.getValue("Name").equals(name)) {
                return a;
            }
            if (!a.getValue("Name").equals(alternate)) continue;
            return a;
        }
        return null;
    }

    @Override
    public Object getValue(String key) {
        return this.properties.get(key);
    }

    @Override
    public void putValue(String key, Object value) {
        Object oldVal = this.properties.put(key, value);
        this.firePropertyChangeEvent(new PropertyChangeEvent(this, key, oldVal, value));
    }

    @Override
    public void setEnabled(boolean b) {
        if (b == this.enabled) {
            return;
        }
        this.enabled = b;
        this.firePropertyChangeEvent(new PropertyChangeEvent(this, "enabled", !b, b));
    }

    public Action findAction(String field, Object value) {
        for (Action a : this) {
            if (a == null) continue;
            if (value.equals(a.getValue(field))) {
                return a;
            }
            if (!(a instanceof ActionList) || (a = ((ActionList)a).findAction(field, value)) == null) continue;
            return a;
        }
        return null;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
    }

    @Override
    public boolean add(Object o) {
        if (!super.add(o)) {
            return false;
        }
        if (o instanceof ViewContextAware && this.context != null) {
            ((ViewContextAware)o).setViewContext(this.context);
        }
        return true;
    }

    @Override
    public boolean remove(Object o) {
        if (!super.remove(o)) {
            return false;
        }
        if (o instanceof ViewContextAware && this.context != null) {
            ((ViewContextAware)o).setViewContext(null);
        }
        return true;
    }

    @Override
    public Object set(int index, Object element) {
        Object old = this.get(index);
        if (old instanceof ViewContextAware && this.context != null) {
            ((ViewContextAware)old).setViewContext(null);
        }
        if (element instanceof ViewContextAware && this.context != null) {
            ((ViewContextAware)element).setViewContext(this.context);
        }
        return super.set(index, element);
    }

    @Override
    public void add(int index, Object element) {
        if (element instanceof ViewContextAware && this.context != null) {
            ((ViewContextAware)element).setViewContext(this.context);
        }
        super.add(index, element);
    }

    @Override
    public Object remove(int index) {
        Object o = super.remove(index);
        if (o instanceof ViewContextAware && this.context != null) {
            ((ViewContextAware)o).setViewContext(null);
        }
        return o;
    }

    @Override
    public String toString() {
        return this.getClass().getName() + "[ name=" + this.getValue("Name") + ", actions=" + super.toString() + "]";
    }
}

