/*
 * Decompiled with CFR 0.152.
 */
package org.progeeks.util.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.progeeks.util.swing.ActionList;
import org.progeeks.util.swing.ActionUtils;
import org.progeeks.util.swing.EnhancedButton;

public class ActionListButton
extends EnhancedButton {
    static final long serialVersionUID = 1L;
    private AbstractButton component;
    private ActionList actions;
    private JPopupMenu popup;
    private ModelSynchronizer modelSynch = new ModelSynchronizer();

    public ActionListButton(ActionList actions) {
        this(null, actions);
    }

    public ActionListButton(AbstractButton component, ActionList actions) {
        this.component = component == null ? this : component;
        this.actions = actions;
        this.setIcon(new ArrowIcon());
        actions.addPropertyChangeListener(new ListObserver());
        this.setModel(new DropDownButtonModel());
        this.getModel().setEnabled(actions.size() > 0);
        this.popup = ActionUtils.createPopupMenu(actions);
        if (this.component != this) {
            this.component.getModel().addChangeListener(this.modelSynch);
            this.getModel().addChangeListener(this.modelSynch);
        }
    }

    public static JComponent createCombinedComponent(ActionListButton actionListButton) {
        if (actionListButton.getParentButton() == null) {
            throw new RuntimeException("ActionListButton has no parent button.");
        }
        JPanel p = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.insets = new Insets(0, 0, 0, 0);
        p.add((Component)actionListButton.getParentButton(), gbc);
        ++gbc.gridx;
        p.add((Component)actionListButton, gbc);
        return p;
    }

    public AbstractButton getParentButton() {
        return this.component != this ? this.component : null;
    }

    private class DropDownButtonModel
    extends DefaultButtonModel {
        static final long serialVersionUID = 1L;

        private DropDownButtonModel() {
        }

        public void fireStateChanged() {
            super.fireStateChanged();
        }

        protected void fireActionPerformed(ActionEvent event) {
            ActionListButton.this.popup.show(ActionListButton.this.component, 0, ActionListButton.this.component.getHeight());
        }

        public boolean isPressed() {
            return ActionListButton.this.popup.isVisible();
        }

        public boolean isRollover() {
            boolean retVal;
            boolean bl = retVal = super.isRollover() || this.isPressed();
            if (!retVal && ActionListButton.this.component != ActionListButton.this && ActionListButton.this.component.getModel().isRollover()) {
                ActionListButton.this.component.getModel().setRollover(retVal);
            }
            return retVal;
        }
    }

    private class ModelSynchronizer
    implements ChangeListener {
        private ModelSynchronizer() {
        }

        public void stateChanged(ChangeEvent event) {
            ButtonModel source = (ButtonModel)event.getSource();
            ButtonModel target = source == ActionListButton.this.component.getModel() ? ActionListButton.this.getModel() : ActionListButton.this.component.getModel();
            target.setRollover(source.isRollover());
        }
    }

    private class ListObserver
    implements PropertyChangeListener {
        private ListObserver() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            ActionListButton.this.getModel().setEnabled(ActionListButton.this.actions.size() > 0);
        }
    }

    private static class ArrowIcon
    implements Icon {
        private ArrowIcon() {
        }

        public int getIconWidth() {
            return 5;
        }

        public int getIconHeight() {
            return 3;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            g.setColor(Color.black);
            g.drawLine(x, y, x + 4, y);
            g.drawLine(++x, ++y, x + 2, y);
            g.drawLine(++x, ++y, x, y);
        }
    }
}

