/*
 * Decompiled with CFR 0.152.
 */
package org.progeeks.util.swing;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ButtonModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.progeeks.util.swing.TogglableAction;

public class CheckBoxAction
extends AbstractAction
implements Cloneable,
TogglableAction {
    static final long serialVersionUID = 1L;
    public static final String PROP_CHECKED = "checked";
    private boolean checked;
    private List<ButtonModel> buttonModels = new ArrayList<ButtonModel>();
    private ButtonListener listener;

    public CheckBoxAction(String name, boolean checked) {
        super(name);
        this.checked = checked;
    }

    public CheckBoxAction(String name) {
        this(name, false);
    }

    public CheckBoxAction() {
    }

    public Object clone() throws CloneNotSupportedException {
        CheckBoxAction action = (CheckBoxAction)super.clone();
        action.changeSupport = null;
        action.buttonModels = new ArrayList<ButtonModel>();
        action.listener = null;
        PropertyChangeListener[] listeners = action.getPropertyChangeListeners();
        for (int i = 0; i < listeners.length; ++i) {
            action.removePropertyChangeListener(listeners[i]);
        }
        return action;
    }

    public void setChecked(boolean checked) {
        if (this.checked == checked) {
            return;
        }
        this.checked = checked;
        this.putValue(PROP_CHECKED, checked);
    }

    public boolean isChecked() {
        return this.checked;
    }

    public void actionPerformed(ActionEvent event) {
    }

    public void addButtonModel(ButtonModel model) {
        this.buttonModels.add(model);
        model.setSelected(this.checked);
        if (this.listener == null) {
            this.listener = new ButtonListener();
        }
        model.addChangeListener(this.listener);
    }

    public void removeButtonModel(ButtonModel model) {
        if (this.listener != null) {
            model.removeChangeListener(this.listener);
        }
        this.buttonModels.remove(model);
    }

    private void updateButtonModels() {
        for (ButtonModel m : this.buttonModels) {
            m.setSelected(this.checked);
        }
    }

    protected void firePropertyChange(String property, Object oldValue, Object newValue) {
        super.firePropertyChange(property, oldValue, newValue);
        if (PROP_CHECKED.equals(property)) {
            this.updateButtonModels();
        }
    }

    private class ButtonListener
    implements ChangeListener {
        private ButtonListener() {
        }

        public void stateChanged(ChangeEvent event) {
            ButtonModel model = (ButtonModel)event.getSource();
            if (model.isSelected() != CheckBoxAction.this.isChecked()) {
                CheckBoxAction.this.setChecked(model.isSelected());
            }
        }
    }
}

