/*
 * Decompiled with CFR 0.152.
 */
package org.progeeks.util.swing;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import org.progeeks.util.ViewContext;
import org.progeeks.util.ViewContextAware;
import org.progeeks.util.swing.AbstractContextAction;
import org.progeeks.util.swing.ActionUtils;

public class CompositeContextAction
extends AbstractContextAction {
    static final long serialVersionUID = 1L;
    private Action pre;
    private Action main;
    private Action post;

    public CompositeContextAction() {
    }

    public CompositeContextAction(Action main) {
        this.setMainAction(main);
    }

    public void setMainAction(Action main) {
        if (this.main != null) {
            throw new RuntimeException("Main action cannot be replaced.");
        }
        this.main = main;
        Object[] keys = this.getKeys();
        if (keys != null) {
            for (int i = 0; i < keys.length; ++i) {
                main.putValue((String)keys[i], super.getValue((String)keys[i]));
            }
        }
        if (main instanceof ViewContextAware) {
            ((ViewContextAware)((Object)main)).setViewContext(this.getViewContext());
        }
        super.setEnabled(main.isEnabled());
        PropertyChangeListener[] listeners = this.getPropertyChangeListeners();
        if (listeners != null) {
            for (int i = 0; i < listeners.length; ++i) {
                main.addPropertyChangeListener(listeners[i]);
                super.removePropertyChangeListener(listeners[i]);
            }
        }
    }

    public Action getMainAction() {
        return this.main;
    }

    public void setPreprocessAction(Action pre) {
        this.pre = pre;
    }

    public Action getPreprocessAction() {
        return this.pre;
    }

    public void setPostprocessAction(Action post) {
        this.post = post;
    }

    public Action getPostprocessAction() {
        return this.post;
    }

    public Object clone() throws CloneNotSupportedException {
        CompositeContextAction clone = (CompositeContextAction)super.clone();
        clone.pre = ActionUtils.cloneAction(this.pre);
        clone.main = ActionUtils.cloneAction(this.main);
        clone.post = ActionUtils.cloneAction(this.post);
        return clone;
    }

    public void setViewContext(ViewContext context) {
        super.setViewContext(context);
        if (this.pre instanceof ViewContextAware) {
            ((ViewContextAware)((Object)this.pre)).setViewContext(context);
        }
        if (this.main instanceof ViewContextAware) {
            ((ViewContextAware)((Object)this.main)).setViewContext(context);
        }
        if (this.post instanceof ViewContextAware) {
            ((ViewContextAware)((Object)this.post)).setViewContext(context);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.main == null) {
            super.addPropertyChangeListener(listener);
        } else {
            this.main.addPropertyChangeListener(listener);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.main == null) {
            super.removePropertyChangeListener(listener);
        } else {
            this.main.removePropertyChangeListener(listener);
        }
    }

    public Object getValue(String key) {
        if (this.main == null) {
            return super.getValue(key);
        }
        return this.main.getValue(key);
    }

    public boolean isEnabled() {
        if (this.main == null) {
            return super.isEnabled();
        }
        return this.main.isEnabled();
    }

    public void setEnabled(boolean b) {
        if (this.main == null) {
            super.setEnabled(b);
            return;
        }
        this.main.setEnabled(b);
    }

    public void putValue(String key, Object value) {
        if (this.main == null) {
            super.putValue(key, value);
            return;
        }
        this.main.putValue(key, value);
    }

    public void actionPerformed(ActionEvent event) {
        if (this.pre != null) {
            this.pre.actionPerformed(event);
        }
        if (this.main != null) {
            this.main.actionPerformed(event);
        }
        if (this.post != null) {
            this.post.actionPerformed(event);
        }
    }
}

