/*
 * Decompiled with CFR 0.152.
 */
package org.progeeks.util.swing;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import javax.swing.Icon;
import javax.swing.SwingConstants;

public class CompositeIcon
implements Icon,
SwingConstants {
    private Icon iconA;
    private Icon iconB;
    private int xOffset;
    private int yOffset;
    private int xAlignment;
    private int yAlignment;
    private int xIconB;
    private int yIconB;
    private int width;
    private int height;
    private boolean invalid = true;

    public CompositeIcon() {
    }

    public CompositeIcon(Icon a, Icon b) {
        this(a, b, 0, 0, 0, 0);
    }

    public CompositeIcon(Icon a, Icon b, int yAlignment) {
        this(a, b, a.getIconWidth(), 0, 2, 0);
    }

    public CompositeIcon(Icon a, Icon b, int xOffset, int yOffset, int xAlignment, int yAlignment) {
        this.iconA = a;
        this.iconB = b;
        this.xOffset = xOffset;
        this.yOffset = yOffset;
        this.xAlignment = xAlignment;
        this.yAlignment = yAlignment;
    }

    public void setIconA(Icon a) {
        this.iconA = a;
        this.invalid = true;
    }

    public Icon getIconA() {
        return this.iconA;
    }

    public void setIconB(Icon b) {
        this.iconB = b;
        this.invalid = true;
    }

    public Icon getIconB() {
        return this.iconB;
    }

    public void setHorizontalAlignment(int align) {
        this.xAlignment = align;
        this.invalid = true;
    }

    public int getHorizontalAlignment() {
        return this.xAlignment;
    }

    public void setVerticalAlignment(int align) {
        this.yAlignment = align;
        this.invalid = true;
    }

    public int getVerticalAlignment() {
        return this.yAlignment;
    }

    public void setOffset(int xOffset, int yOffset) {
        this.xOffset = xOffset;
        this.yOffset = yOffset;
        this.invalid = true;
    }

    public Point getOffset() {
        return new Point(this.xOffset, this.yOffset);
    }

    public void setOffsetX(int xOffset) {
        this.setOffset(xOffset, this.yOffset);
    }

    public int getOffsetX() {
        return this.xOffset;
    }

    public void setOffsetY(int yOffset) {
        this.setOffset(this.xOffset, yOffset);
    }

    public int getOffsetY() {
        return this.yOffset;
    }

    protected void recalculate() {
        this.xIconB = 0;
        this.yIconB = 0;
        this.width = 0;
        this.height = 0;
        int widthA = 0;
        int heightA = 0;
        int widthB = 0;
        int heightB = 0;
        if (this.iconA != null) {
            widthA = this.iconA.getIconWidth();
            heightA = this.iconA.getIconHeight();
        }
        if (this.iconB != null) {
            widthB = this.iconB.getIconWidth();
            heightB = this.iconB.getIconHeight();
        }
        if (this.iconB == null) {
            if (this.iconA != null) {
                this.width = widthA;
                this.height = heightA;
            }
            return;
        }
        if (this.xAlignment == 0) {
            this.xIconB = widthA / 2 - widthB / 2;
        } else if (this.xAlignment == 4) {
            this.xIconB = widthA - widthB;
        }
        if (this.yAlignment == 0) {
            this.yIconB = heightA / 2 - heightB / 2;
        } else if (this.yAlignment == 3) {
            this.yIconB = heightA - heightB;
        }
        this.xIconB += this.xOffset;
        this.yIconB += this.yOffset;
        int left = Math.min(this.xIconB, 0);
        int right = Math.max(this.xIconB + widthB, widthA);
        int top = Math.min(this.yIconB, 0);
        int bottom = Math.max(this.yIconB + heightB, heightA);
        this.width = right - left;
        this.height = bottom - top;
        this.invalid = false;
    }

    public void paintIcon(Component c, Graphics g, int x, int y) {
        if (this.xIconB < 0) {
            x -= this.xIconB;
        }
        if (this.yIconB < 0) {
            y -= this.yIconB;
        }
        if (this.invalid) {
            this.recalculate();
        }
        if (this.iconA != null) {
            this.iconA.paintIcon(c, g, x, y);
        }
        if (this.iconB != null) {
            this.iconB.paintIcon(c, g, x + this.xIconB, y + this.yIconB);
        }
    }

    public int getIconWidth() {
        if (this.invalid) {
            this.recalculate();
        }
        return this.width;
    }

    public int getIconHeight() {
        if (this.invalid) {
            this.recalculate();
        }
        return this.height;
    }
}

