/*
 * Decompiled with CFR 0.152.
 */
package org.progeeks.util.swing;

import java.awt.Color;
import java.awt.Graphics;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.border.Border;
import org.progeeks.util.swing.LightBevelBorder;

public class EnhancedButton
extends JButton {
    static final long serialVersionUID = 1L;
    protected Border raisedBorder = new LightBevelBorder(0);
    protected Border loweredBorder = new LightBevelBorder(1);
    private static Color pressedColor = null;
    private static Color selectedColor = null;
    protected boolean alwaysPaintBorder = false;

    public EnhancedButton() {
    }

    public EnhancedButton(Icon icon) {
        super(icon);
    }

    public EnhancedButton(String text) {
        super(text);
    }

    public EnhancedButton(Action a) {
        super(a);
    }

    public EnhancedButton(String text, Icon icon) {
        super(text, icon);
    }

    public void setAlwaysPaintBorder(boolean alwaysPaint) {
        this.alwaysPaintBorder = alwaysPaint;
    }

    public boolean isAlwaysPaintBorder() {
        return this.alwaysPaintBorder;
    }

    public boolean isFocusPainted() {
        return false;
    }

    protected static void setColors(Color background) {
        if (background == null) {
            return;
        }
        int red = background.getRed();
        int green = background.getGreen();
        int blue = background.getBlue();
        selectedColor = red > 245 && green > 245 && blue > 245 ? Color.gray : new Color(Math.min(255, red + 10), Math.min(255, green + 10), Math.min(255, blue + 10));
        pressedColor = red < 10 && green < 10 && blue < 10 ? Color.gray : new Color(Math.max(0, red - 10), Math.max(0, green - 10), Math.max(0, blue - 10));
    }

    public Color getBackground() {
        if (pressedColor == null) {
            EnhancedButton.setColors(super.getBackground());
        }
        if (this.model.isPressed()) {
            return pressedColor;
        }
        if (this.model.isSelected()) {
            return selectedColor;
        }
        return super.getBackground();
    }

    public Border getBorder() {
        if (this.model.isPressed() || this.model.isSelected()) {
            return this.loweredBorder;
        }
        return this.raisedBorder;
    }

    public Icon getIcon() {
        Icon rollover;
        if ((this.model.isRollover() || this.model.isSelected()) && (rollover = this.getRolloverIcon()) != null) {
            return rollover;
        }
        return super.getIcon();
    }

    protected void paintBorder(Graphics g) {
        if (this.alwaysPaintBorder || this.model.isRollover() || this.model.isSelected() || this.hasFocus()) {
            super.paintBorder(g);
        }
    }
}

