/*
 * Decompiled with CFR 0.152.
 */
package org.progeeks.util.swing;

import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.plaf.basic.BasicTabbedPaneUI;
import org.progeeks.util.ListPropertyChangeListener;
import org.progeeks.util.ObservableList;
import org.progeeks.util.log.Log;

public abstract class ListTabbedPane
extends JTabbedPane {
    static Log log = Log.getLog(ListTabbedPane.class);
    private boolean hasCloseButtons;
    private ObservableList objects;
    private ListObserver observer = new ListObserver();
    private List<Object> tabs = new ArrayList<Object>();

    public ListTabbedPane() {
        this(false);
    }

    public ListTabbedPane(boolean hasCloseButtons) {
        this.hasCloseButtons = hasCloseButtons;
        this.setTabLayoutPolicy(1);
        if (hasCloseButtons) {
            this.setUI(new CloseButtonUI());
        }
    }

    public Object getSelectedMetaObject() {
        int i = this.getSelectedIndex();
        if (i < 0) {
            return null;
        }
        return this.objects.get(i);
    }

    public void setSelectedMetaObject(Object mObj) {
        int i = this.objects.indexOf(mObj);
        if (i < 0) {
            return;
        }
        this.setSelectedIndex(i);
    }

    public void setList(ObservableList list) {
        if (this.objects == list) {
            return;
        }
        if (this.objects != null) {
            this.objects.removePropertyChangeListener(this.observer);
            this.removeAll();
            this.tabs.clear();
        }
        this.objects = list;
        if (this.objects != null) {
            this.objects.addPropertyChangeListener(this.observer);
            int index = 0;
            for (Object mObj : list) {
                this.insertObjectTab(index++, mObj);
            }
        }
    }

    public ObservableList getList() {
        return this.objects;
    }

    protected abstract Component createTab(Object var1);

    protected abstract String getName(Object var1);

    protected void tabRemoved(Component tab, Object obj) {
    }

    protected void insertObjectTab(int index, Object obj) {
        if (obj == null) {
            this.tabs.add(index, null);
            super.insertTab("Unknown", null, new JPanel(), null, index);
            return;
        }
        Component tab = this.createTab(obj);
        this.tabs.add(index, tab);
        super.insertTab(this.getName(obj), null, tab, null, index);
    }

    protected void removeObjectTab(int index, Object obj) {
        Component comp = (Component)this.tabs.remove(index);
        this.tabRemoved(comp, obj);
        super.remove(index);
    }

    private class CloseButtonUI
    extends BasicTabbedPaneUI {
        protected int calculateTabWidth(int tabPlacement, int tabIndex, FontMetrics metrics) {
            return super.calculateTabWidth(tabPlacement, tabIndex, metrics) + 24;
        }

        protected int getTabLabelShiftX(int tabPlacement, int tabIndex, boolean isSelected) {
            return super.getTabLabelShiftX(tabPlacement, tabIndex, isSelected) - 10;
        }

        protected MouseListener createMouseListener() {
            return new TabMouseHandler();
        }

        protected void paintTab(Graphics g, int tabPlacement, Rectangle[] rects, int tabIndex, Rectangle iconRect, Rectangle textRect) {
            super.paintTab(g, tabPlacement, rects, tabIndex, iconRect, textRect);
            Rectangle rect = rects[tabIndex];
            g.drawRect(rect.x + rect.width - 19, rect.y + 4, 13, 12);
            g.drawLine(rect.x + rect.width - 16, rect.y + 7, rect.x + rect.width - 10, rect.y + 13);
            g.drawLine(rect.x + rect.width - 10, rect.y + 7, rect.x + rect.width - 16, rect.y + 13);
            g.drawLine(rect.x + rect.width - 15, rect.y + 7, rect.x + rect.width - 9, rect.y + 13);
            g.drawLine(rect.x + rect.width - 9, rect.y + 7, rect.x + rect.width - 15, rect.y + 13);
        }

        private class TabMouseHandler
        extends BasicTabbedPaneUI.MouseHandler {
            public TabMouseHandler() {
                super(CloseButtonUI.this);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void mouseReleased(MouseEvent e) {
                int x = e.getX();
                int y = e.getY();
                int tabIndex = -1;
                int tabCount = CloseButtonUI.this.tabPane.getTabCount();
                for (int i = 0; i < tabCount; ++i) {
                    if (!CloseButtonUI.this.rects[i].contains(x, y)) continue;
                    tabIndex = i;
                    break;
                }
                if (tabIndex >= 0 && !e.isPopupTrigger()) {
                    Rectangle tabRect = CloseButtonUI.this.rects[tabIndex];
                    if (x >= tabRect.x + tabRect.width - 18 && x <= tabRect.x + tabRect.width - 8 && (y -= tabRect.y) >= 5 && y <= 15 && ListTabbedPane.this.objects != null) {
                        try {
                            ListTabbedPane.this.observer.ignore();
                            Object obj = ListTabbedPane.this.objects.remove(tabIndex);
                            ListTabbedPane.this.removeObjectTab(tabIndex, obj);
                        }
                        finally {
                            ListTabbedPane.this.observer.watch();
                        }
                    }
                }
            }
        }
    }

    private class ListObserver
    extends ListPropertyChangeListener {
        private int ignoreEvents = 0;

        private ListObserver() {
        }

        public void ignore() {
            ++this.ignoreEvents;
        }

        public void watch() {
            --this.ignoreEvents;
        }

        protected void itemInserted(Object source, int index, List oldList, List newList) {
            if (this.ignoreEvents > 0) {
                return;
            }
            ListTabbedPane.this.insertObjectTab(index, newList.get(index));
            ListTabbedPane.this.setSelectedIndex(index);
        }

        protected void itemUpdated(Object source, int index, List oldList, List newList) {
            if (this.ignoreEvents > 0) {
                return;
            }
            throw new UnsupportedOperationException("Tab replacement not supported yet.");
        }

        protected void itemDeleted(Object source, int index, List oldList, List newList) {
            if (this.ignoreEvents > 0) {
                return;
            }
            ListTabbedPane.this.removeObjectTab(index, oldList.get(index));
        }
    }
}

