/*
 * Decompiled with CFR 0.152.
 */
package org.progeeks.util.swing;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.progeeks.util.log.Log;
import org.progeeks.util.swing.ActionList;
import org.progeeks.util.swing.CheckBoxAction;

public class LookAndFeelActions
extends ActionList {
    static final long serialVersionUID = 1L;
    static Log log = Log.getLog(LookAndFeelActions.class);

    public LookAndFeelActions(String name) {
        super(name);
        UIManager.LookAndFeelInfo[] list = UIManager.getInstalledLookAndFeels();
        for (int i = 0; i < list.length; ++i) {
            this.add(new SetPlafAction(list[i]));
        }
    }

    private static class SetPlafAction
    extends CheckBoxAction
    implements PropertyChangeListener {
        static final long serialVersionUID = 1L;
        private UIManager.LookAndFeelInfo info;

        public SetPlafAction(UIManager.LookAndFeelInfo info) {
            super(info.getName());
            this.info = info;
            UIManager.addPropertyChangeListener(this);
            this.setChecked(UIManager.getLookAndFeel().getName().equals(info.getName()));
        }

        public void propertyChange(PropertyChangeEvent event) {
            if ("lookAndFeel".equals(event.getPropertyName())) {
                LookAndFeel laf = (LookAndFeel)event.getNewValue();
                this.setChecked(laf.getName().equals(this.info.getName()));
            }
        }

        public void actionPerformed(ActionEvent event) {
            try {
                UIManager.setLookAndFeel(this.info.getClassName());
                Frame[] frames = Frame.getFrames();
                for (int i = 0; i < frames.length; ++i) {
                    SwingUtilities.updateComponentTreeUI(frames[i]);
                }
            }
            catch (Exception e) {
                log.error("Error setting look and feel:" + this.info.getName(), e);
            }
        }
    }
}

