/*
 * Decompiled with CFR 0.152.
 */
package org.progeeks.util.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.progeeks.util.swing.EnhancedButton;

public class RolloutPanel
extends JPanel {
    static final long serialVersionUID = 1L;
    private static final Dimension ZERO_SIZE = new Dimension(0, 0);
    private static Icon openIcon;
    private static Icon closeIcon;
    private String title;
    private EnhancedButton titleButton;
    private JComponent panel;
    private Font smaller;
    private boolean open = true;
    private List<ChangeListener> rolloutListeners = new ArrayList<ChangeListener>();
    private ChangeEvent changeEvent = new ChangeEvent(this);

    public RolloutPanel() {
        this(null, null);
    }

    public RolloutPanel(String title, JComponent panel) {
        this.title = title;
        this.panel = panel;
        this.buildContents();
    }

    public void addChangeListener(ChangeListener listener) {
        this.rolloutListeners.add(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.rolloutListeners.remove(listener);
    }

    protected void fireChangeEvent() {
        ChangeListener[] list = new ChangeListener[this.rolloutListeners.size()];
        list = this.rolloutListeners.toArray(list);
        for (int i = 0; i < list.length; ++i) {
            list[i].stateChanged(this.changeEvent);
        }
    }

    public void setTitle(String title) {
        this.titleButton.setText(title);
    }

    public String getTitle() {
        return this.title;
    }

    public void setRolloutPanel(JComponent panel) {
        if (this.panel != null) {
            this.remove(this.panel);
        }
        this.panel = panel;
        if (panel != null) {
            this.add((Component)panel, "Center");
            panel.setFont(this.smaller);
        }
    }

    public JComponent getRolloutPanel() {
        return this.panel;
    }

    public void openRollout() {
        if (this.open) {
            return;
        }
        this.titleButton.setIcon(closeIcon);
        this.add((Component)this.panel, "Center");
        this.open = true;
        this.revalidate();
        this.fireChangeEvent();
        this.repaint();
    }

    public void closeRollout() {
        if (!this.open) {
            return;
        }
        this.titleButton.setIcon(openIcon);
        this.remove(this.panel);
        this.open = false;
        this.revalidate();
        this.fireChangeEvent();
        this.repaint();
    }

    public Dimension getPreferredSize() {
        if (this.open) {
            return super.getPreferredSize();
        }
        Dimension d1 = this.titleButton.getPreferredSize();
        Dimension d2 = this.panel.getPreferredSize();
        return new Dimension(d2.width, d1.height);
    }

    public Dimension getMinimumSize() {
        if (this.open) {
            return super.getMinimumSize();
        }
        Dimension d1 = this.titleButton.getMinimumSize();
        Dimension d2 = this.panel.getMinimumSize();
        return new Dimension(d2.width, d1.height);
    }

    protected void buildContents() {
        this.setLayout(new BorderLayout());
        this.titleButton = new EnhancedButton(this.title);
        this.titleButton.setAlwaysPaintBorder(true);
        this.titleButton.setMargin(new Insets(0, 0, 0, 0));
        this.titleButton.addActionListener(new ButtonListener());
        this.titleButton.setIcon(closeIcon);
        this.titleButton.setHorizontalTextPosition(10);
        this.add((Component)this.titleButton, "North");
        if (this.panel != null) {
            this.add((Component)this.panel, "Center");
            this.panel.setFont(this.smaller);
        }
    }

    static {
        try {
            openIcon = new ImageIcon(RolloutPanel.class.getResource("plus.png"));
            closeIcon = new ImageIcon(RolloutPanel.class.getResource("minus.png"));
        }
        catch (Exception e) {
            throw new RuntimeException("Error loading open/close icons", e);
        }
    }

    private class ButtonListener
    implements ActionListener {
        private ButtonListener() {
        }

        public void actionPerformed(ActionEvent event) {
            if (event.getSource() == RolloutPanel.this.titleButton) {
                if (RolloutPanel.this.open) {
                    RolloutPanel.this.closeRollout();
                } else {
                    RolloutPanel.this.openRollout();
                }
            }
        }
    }
}

