/*
 * Decompiled with CFR 0.152.
 */
package org.progeeks.util.swing;

import java.awt.Component;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.UIManager;
import org.progeeks.util.ProgressReporter;

public class SwingProgressReporter
implements ProgressReporter {
    private JProgressBar bar = new JProgressBar();
    private JOptionPane pane;
    private JDialog dialog;
    private JLabel messageLabel;

    public SwingProgressReporter(Component parent, String title, String message, int min, int max) {
        this.bar.setMinimum(min);
        this.bar.setMaximum(max);
        this.bar.setValue(min);
        this.bar.setIndeterminate(this.shouldBeIndeterminate());
        if (message == null) {
            message = "";
        }
        this.messageLabel = new JLabel(message);
        this.pane = new JOptionPane(new Object[]{title, this.messageLabel, this.bar}, 1, -1, null, new Object[]{UIManager.getString("OptionPane.cancelButtonText")}, null);
        this.dialog = this.pane.createDialog(parent, UIManager.getString("ProgressMonitor.progressText"));
        this.dialog.setModal(false);
        this.dialog.setVisible(true);
    }

    protected boolean shouldBeIndeterminate() {
        int max;
        int min = this.bar.getMinimum();
        return min == (max = this.bar.getMaximum()) && min == -1;
    }

    public void setMessage(String message) {
        this.messageLabel.setText(message);
        this.dialog.pack();
    }

    public String getMessage() {
        return this.messageLabel.getText();
    }

    public void setProgress(int val) {
        this.bar.setValue(val);
    }

    public int getProgress() {
        return this.bar.getValue();
    }

    public void setMinimum(int val) {
        this.bar.setMinimum(val);
        this.bar.setIndeterminate(this.shouldBeIndeterminate());
    }

    public int getMinimum() {
        return this.bar.getMinimum();
    }

    public void setMaximum(int val) {
        this.bar.setMaximum(val);
        this.bar.setIndeterminate(this.shouldBeIndeterminate());
    }

    public int getMaximum() {
        return this.bar.getMaximum();
    }

    public boolean isCanceled() {
        Object val = this.pane.getValue();
        if (val == null) {
            return false;
        }
        return val.equals(UIManager.getString("OptionPane.cancelButtonText"));
    }

    public void done() {
        if (this.dialog != null) {
            this.dialog.setVisible(false);
            this.dialog.dispose();
            this.dialog = null;
            this.pane = null;
            this.bar = null;
        }
    }
}

