/*
 * Decompiled with CFR 0.152.
 */
package org.progeeks.util.swing;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import org.progeeks.util.AbstractRequestHandler;
import org.progeeks.util.ExtensionFileFilter;
import org.progeeks.util.ProgressReporter;
import org.progeeks.util.swing.SwingProgressReporter;
import org.progeeks.util.swing.SwingThreadInvoker;

public class SwingRequestHandler
extends AbstractRequestHandler {
    private static Map<String, File> filePaths = new HashMap<String, File>();
    private static File lastDir = null;
    private static JFileChooser fileChooser;
    private Component contextWindow;

    public SwingRequestHandler(Component contextWindow) {
        this.contextWindow = contextWindow;
    }

    public Component getContextWindow() {
        return this.contextWindow;
    }

    public Boolean requestConfirmation(String title, String message, boolean includeCancel) {
        return SwingRequestHandler.getConfirmation(this.contextWindow, title, message, includeCancel);
    }

    public File requestFile(String title, String typeDescription, String extension, boolean forOpen) {
        return SwingRequestHandler.getFile(this.contextWindow, title, typeDescription, extension, null, forOpen, 0);
    }

    public File requestFile(String title, String typeDescription, String extension, File initialValue, boolean forOpen) {
        return SwingRequestHandler.getFile(this.contextWindow, title, typeDescription, extension, initialValue, forOpen, 0);
    }

    public List requestFiles(String title, String typeDescription, String extension, File initialValue, boolean forOpen) {
        return SwingRequestHandler.getFiles(this.contextWindow, title, typeDescription, extension, initialValue, forOpen, 0);
    }

    public File requestDirectory(String title) {
        return SwingRequestHandler.getFile(this.contextWindow, title, "Directory", "", null, true, 1);
    }

    public String requestString(String title, String message, String initialValue) {
        return SwingRequestHandler.getString(this.contextWindow, title, message, initialValue);
    }

    public void requestShowMessage(String message) {
        JOptionPane.showMessageDialog(this.contextWindow, message);
    }

    public void requestShowMessage(String title, String message, int type) {
        if (type == -1) {
            type = -1;
        }
        JOptionPane.showMessageDialog(this.contextWindow, message, title, type);
    }

    public void requestShowError(String title, String message) {
        JOptionPane.showMessageDialog(this.contextWindow, message, title, 0);
    }

    public ProgressReporter requestProgressReporter(String title, String message, int min, int max) {
        if (message == null) {
            message = "Processing...";
        }
        ProgressReporter pr = new SwingProgressReporter(this.contextWindow, title, message, min, max);
        pr = (ProgressReporter)SwingThreadInvoker.synchronizeObject(pr, ProgressReporter.class);
        return pr;
    }

    public static Boolean getConfirmation(Component owner, String title, String message, boolean includeCancel) {
        int type = includeCancel ? 1 : 0;
        int result = JOptionPane.showConfirmDialog(owner, message, title, type);
        switch (result) {
            case 0: {
                return Boolean.TRUE;
            }
            case 1: {
                return Boolean.FALSE;
            }
        }
        return null;
    }

    public static File getFile(Component owner, String title, String typeDescription, String extension, File initialValue, boolean forOpen, int mode) {
        return SwingRequestHandler.getFile(owner, title, new ExtensionFileFilter(typeDescription, extension), initialValue, forOpen, mode);
    }

    public static File getFile(Component owner, String title, FileFilter filter, File initialValue, boolean forOpen, int mode) {
        String name;
        int returnVal;
        File f = filePaths.get(String.valueOf(filter));
        if (f == null) {
            f = lastDir;
        }
        String extension = "";
        if (filter instanceof ExtensionFileFilter) {
            extension = ((ExtensionFileFilter)filter).getExtensionsString();
        }
        if (fileChooser == null) {
            fileChooser = new JFileChooser(f);
        } else {
            fileChooser.setCurrentDirectory(f);
        }
        fileChooser.setFileFilter(filter);
        fileChooser.setDialogTitle(title);
        fileChooser.setFileSelectionMode(mode);
        fileChooser.setMultiSelectionEnabled(false);
        if (initialValue != null) {
            fileChooser.setSelectedFile(initialValue);
        }
        if ((returnVal = forOpen ? fileChooser.showOpenDialog(owner) : fileChooser.showSaveDialog(owner)) != 0) {
            return null;
        }
        File selected = fileChooser.getSelectedFile();
        lastDir = selected.getParentFile();
        filePaths.put(String.valueOf(filter), lastDir);
        if (!forOpen && extension.length() > 0 && extension.indexOf(",") < 0 && !(name = selected.getName()).toLowerCase().endsWith("." + extension.toLowerCase())) {
            name = name + "." + extension;
            selected = new File(lastDir, name);
        }
        return selected;
    }

    public static List getFiles(Component owner, String title, String typeDescription, String extension, File initialValue, boolean forOpen, int mode) {
        return SwingRequestHandler.getFiles(owner, title, new ExtensionFileFilter(typeDescription, extension), initialValue, forOpen, mode);
    }

    public static List getFiles(Component owner, String title, FileFilter filter, File initialValue, boolean forOpen, int mode) {
        int returnVal;
        File f = filePaths.get(String.valueOf(filter));
        if (f == null) {
            f = lastDir;
        }
        String extension = "";
        if (filter instanceof ExtensionFileFilter) {
            extension = ((ExtensionFileFilter)filter).getExtensionsString();
        }
        if (fileChooser == null) {
            fileChooser = new JFileChooser(f);
        } else {
            fileChooser.setCurrentDirectory(f);
        }
        fileChooser.setFileFilter(filter);
        fileChooser.setDialogTitle(title);
        fileChooser.setFileSelectionMode(mode);
        fileChooser.setMultiSelectionEnabled(true);
        if (initialValue != null) {
            fileChooser.setSelectedFile(initialValue);
        }
        if ((returnVal = forOpen ? fileChooser.showOpenDialog(owner) : fileChooser.showSaveDialog(owner)) != 0) {
            return null;
        }
        List<File> selected = Arrays.asList(fileChooser.getSelectedFiles());
        File firstFile = null;
        for (int i = 0; i < selected.size(); ++i) {
            File s = selected.get(i);
            if (firstFile == null) {
                firstFile = s;
            }
            if (forOpen || extension.length() <= 0 || extension.indexOf(",") >= 0) continue;
            String name = s.getName();
            File dir = s.getParentFile();
            if (name.toLowerCase().endsWith("." + extension.toLowerCase())) continue;
            name = name + "." + extension;
            s = new File(dir, name);
            selected.set(i, s);
        }
        if (firstFile != null) {
            lastDir = firstFile.getParentFile();
            filePaths.put(String.valueOf(filter), lastDir);
        }
        return selected;
    }

    public static String getString(Component owner, String title, String message, String initialValue) {
        return (String)JOptionPane.showInputDialog(owner, message, title, -1, null, null, initialValue);
    }

    static {
        lastDir = new File(".");
        try {
            lastDir = lastDir.getCanonicalFile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

