/*
 * Decompiled with CFR 0.152.
 */
package org.progeeks.util.swing;

import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.progeeks.util.log.Log;
import org.progeeks.util.swing.SortedTableModel;

public class TableUtils {
    static Log log = Log.getLog(TableUtils.class);

    public static void resizeColumns(JTable table) {
        TableColumnModel colModel = table.getColumnModel();
        for (int column = table.getColumnCount() - 1; column >= 0; --column) {
            TableColumn col;
            int width = TableUtils.getPreferredColumnWidth(table, column);
            if (width <= (col = colModel.getColumn(column)).getPreferredWidth()) continue;
            col.setPreferredWidth(width);
        }
    }

    public static int getPreferredHeaderWidth(JTable table, int column) {
        TableColumn col = table.getColumnModel().getColumn(column);
        TableCellRenderer renderer = col.getHeaderRenderer();
        if (renderer != null) {
            Component c = renderer.getTableCellRendererComponent(table, col.getHeaderValue(), false, false, 0, 0);
            return c.getPreferredSize().width;
        }
        return 0;
    }

    public static int getPreferredColumnWidth(JTable table, int column) {
        TableModel model = table.getModel();
        TableColumn col = table.getColumnModel().getColumn(column);
        TableCellRenderer renderer = col.getCellRenderer();
        int preferredWidth = TableUtils.getPreferredHeaderWidth(table, column);
        if (renderer == null) {
            renderer = table.getDefaultRenderer(model.getColumnClass(column));
        }
        if (renderer == null) {
            return preferredWidth;
        }
        int modelColumn = table.convertColumnIndexToModel(column);
        System.out.println("col:" + column + "  model:" + modelColumn);
        for (int row = 0; row < model.getRowCount(); ++row) {
            Component c = renderer.getTableCellRendererComponent(table, model.getValueAt(row, modelColumn), false, false, 0, column);
            int width = c.getPreferredSize().width;
            if (width <= preferredWidth) continue;
            preferredWidth = width;
        }
        return preferredWidth;
    }

    public static void addSortDecorators(JTable table) {
        JTableHeader header = table.getTableHeader();
        HeaderMouseListener ml = new HeaderMouseListener(table);
        header.addMouseListener(ml);
    }

    private static class HeaderMouseListener
    extends MouseAdapter {
        private JTable table;

        public HeaderMouseListener(JTable table) {
            this.table = table;
        }

        protected int getResizeColumn(MouseEvent e) {
            JTableHeader header = this.table.getTableHeader();
            int col = header.columnAtPoint(e.getPoint());
            int x = e.getX();
            if (x < 3) {
                return -1;
            }
            Rectangle rect = header.getHeaderRect(col);
            if ((double)x - rect.getX() < 3.0) {
                return col - 1;
            }
            if (rect.getX() + rect.getWidth() - 1.0 - (double)x < 3.0) {
                return col;
            }
            return -1;
        }

        protected boolean processResize(MouseEvent e) {
            int resizeCol = this.getResizeColumn(e);
            if (resizeCol < 0) {
                return false;
            }
            if (e.getClickCount() <= 1) {
                return true;
            }
            int width = TableUtils.getPreferredColumnWidth(this.table, resizeCol);
            TableColumn tc = this.table.getColumnModel().getColumn(resizeCol);
            tc.setPreferredWidth(width + 1);
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void mouseClicked(MouseEvent e) {
            if (!(this.table.getModel() instanceof SortedTableModel)) {
                return;
            }
            JTableHeader header = this.table.getTableHeader();
            if (!header.isEnabled()) {
                return;
            }
            if (this.processResize(e)) {
                return;
            }
            SortedTableModel sortedModel = (SortedTableModel)this.table.getModel();
            int col = header.columnAtPoint(e.getPoint());
            TableColumnModel tcm = header.getColumnModel();
            TableColumn tc = tcm.getColumn(col);
            int index = tc.getModelIndex();
            if (sortedModel.getPrimarySortColumn() == index) {
                sortedModel.setReversed(!sortedModel.isReversed());
            } else if (sortedModel.isSortable(index)) {
                sortedModel.pushSortColumn(index);
            } else {
                log.warn("Table column is not sortable:" + index);
            }
        }
    }
}

