/*
 * Decompiled with CFR 0.152.
 */
package org.progeeks.util.swing;

import java.awt.Point;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JFrame;
import javax.swing.JRootPane;
import org.progeeks.util.ClassRegistry;
import org.progeeks.util.ContextView;
import org.progeeks.util.ListPropertyChangeEvent;
import org.progeeks.util.ObservableList;
import org.progeeks.util.ViewContext;
import org.progeeks.util.ViewManager;
import org.progeeks.util.log.Log;
import org.progeeks.util.swing.WindowFactory;

public class WindowManager
implements ViewManager {
    static Log log = Log.getLog(WindowManager.class);
    public static final WindowFactory NULL_FACTORY = new NoOpFactory();
    private ObservableList contexts;
    private ContextListener contextListener = new ContextListener();
    private ClassRegistry factories = new ClassRegistry();
    private Map<ViewContext, Window> viewMap = new HashMap<ViewContext, Window>();
    private Map<Window, Window> parentMap = new HashMap<Window, Window>();
    private List<Window> windows = new ArrayList<Window>();
    private WindowStateListener windowListener = new WindowStateListener();
    private boolean cascade = true;
    private boolean exitWhenLastViewRemoved = true;

    public WindowManager() {
    }

    public WindowManager(ObservableList contexts) {
        this(contexts, null);
    }

    public WindowManager(ObservableList contexts, ClassRegistry factories) {
        if (factories != null) {
            this.factories = factories;
        }
        this.setContextList(contexts);
    }

    public void setContextList(ObservableList contexts) {
        if (this.contexts != null) {
            this.contexts.removePropertyChangeListener(this.contextListener);
        }
        this.contexts = contexts;
        if (this.contexts != null) {
            this.contexts.addPropertyChangeListener(this.contextListener);
        }
    }

    public ObservableList getContextList() {
        return this.contexts;
    }

    public void setViewFactories(ClassRegistry factories) {
        this.factories = factories;
    }

    public ClassRegistry getViewFactories() {
        return this.factories;
    }

    public void setExitWhenLastViewRemoved(boolean exitWhenLastViewRemoved) {
        this.exitWhenLastViewRemoved = exitWhenLastViewRemoved;
    }

    public boolean getExitWhenLastViewRemoved() {
        return this.exitWhenLastViewRemoved;
    }

    public void setCascade(boolean cascade) {
        this.cascade = cascade;
    }

    public boolean getCascade() {
        return this.cascade;
    }

    public void createInitialViews() {
        for (ViewContext context : this.contexts) {
            if (this.viewMap.containsKey(context)) continue;
            this.viewAdded(context);
        }
    }

    public void registerWindowFactory(Class contextType, WindowFactory factory) {
        if (!ViewContext.class.isAssignableFrom(contextType)) {
            throw new RuntimeException("Type:" + contextType + " does not implement ViewContext.");
        }
        this.factories.put(contextType, factory);
    }

    protected Window getLastVisibleWindow() {
        for (int i = this.windows.size() - 1; i >= 0; --i) {
            Window last = this.windows.get(i);
            if (!last.isVisible()) continue;
            return last;
        }
        return null;
    }

    protected void viewAdded(ViewContext context) {
        Window view;
        WindowFactory factory;
        if (log.isInfoEnabled()) {
            log.info("Adding view for:" + context);
        }
        if ((factory = (WindowFactory)this.factories.get(context.getClass())) == null) {
            throw new RuntimeException("Window factory not found that can handle context type:" + context.getClass());
        }
        if (factory == NULL_FACTORY) {
            return;
        }
        Window parent = null;
        if (context.getParentContext() != null) {
            parent = this.viewMap.get(context.getParentContext());
        }
        if (parent != null) {
            view = factory.createViewWindow(parent, context);
            this.parentMap.put(view, parent);
        } else {
            view = factory.createViewWindow(context);
        }
        if (view == null) {
            log.warn("Factory:" + factory + "  return null view.  So ignoring added context:" + context);
            return;
        }
        if (this.cascade && view.getX() == 0 && view.getY() == 0 && this.windows.size() > 0) {
            Point delta = new Point(25, 25);
            Window last = this.getLastVisibleWindow();
            if (last != null) {
                Point corner = last.getLocation();
                if (last instanceof JFrame) {
                    JRootPane rootPane = ((JFrame)last).getRootPane();
                    delta = rootPane.getLocation();
                    delta.x = delta.y;
                }
                view.setLocation(corner.x + delta.x, corner.y + delta.y);
            }
        }
        this.viewMap.put(context, view);
        this.windows.add(view);
        view.addWindowListener(this.windowListener);
        view.setVisible(true);
        view.toFront();
    }

    protected void viewRemoved(ViewContext context) {
        Window view;
        if (log.isInfoEnabled()) {
            log.info("Removing view for:" + context);
        }
        if ((view = this.viewMap.get(context)) == null) {
            log.info("Ignoring context removal:" + context);
            return;
        }
        this.windows.remove(view);
        view.dispose();
        this.viewMap.remove(context);
        if (this.exitWhenLastViewRemoved && this.viewMap.size() == 0) {
            log.info("Exiting application.");
            System.exit(0);
        }
    }

    private static final class NoOpFactory
    implements WindowFactory {
        private NoOpFactory() {
        }

        public Window createViewWindow(ViewContext context) {
            return null;
        }

        public Window createViewWindow(Window owner, ViewContext context) {
            return null;
        }
    }

    private class WindowStateListener
    extends WindowAdapter {
        private WindowStateListener() {
        }

        public void windowClosing(WindowEvent event) {
            if (log.isInfoEnabled()) {
                log.info("Window closing:" + event.getSource());
            }
            ContextView view = (ContextView)event.getSource();
            ViewContext ctx = view.getViewContext();
            WindowManager.this.contexts.remove(ctx);
        }

        public void windowClosed(WindowEvent event) {
            if (log.isInfoEnabled()) {
                log.info("Window closed:" + event.getSource());
            }
            ContextView view = (ContextView)event.getSource();
            ViewContext ctx = view.getViewContext();
            WindowManager.this.viewMap.remove(ctx);
            Window parent = (Window)WindowManager.this.parentMap.remove(view);
            if (parent != null) {
                log.info("Activating parent window.");
                parent.toFront();
            }
        }
    }

    private class ContextListener
    implements PropertyChangeListener {
        private ContextListener() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            if (!(event instanceof ListPropertyChangeEvent)) {
                return;
            }
            ListPropertyChangeEvent lce = (ListPropertyChangeEvent)event;
            List oldList = (List)lce.getOldValue();
            List newList = (List)lce.getNewValue();
            switch (lce.getType()) {
                case 0: {
                    for (int i = lce.getFirstIndex(); i <= lce.getLastIndex(); ++i) {
                        WindowManager.this.viewAdded((ViewContext)newList.get(i));
                    }
                    break;
                }
                case 1: {
                    throw new UnsupportedOperationException("View contexts cannot be swapped.");
                }
                case 2: {
                    for (int i = lce.getFirstIndex(); i <= lce.getLastIndex(); ++i) {
                        WindowManager.this.viewRemoved((ViewContext)oldList.get(i));
                    }
                    break;
                }
            }
        }
    }
}

