/*
 * Decompiled with CFR 0.152.
 */
package org.progeeks.util.thread;

public class CircularQueue {
    public static final int DEFAULT_CAPACITY = 100;
    protected int capacity;
    protected int head;
    protected int tail;
    protected Object[] data;

    public CircularQueue() {
        this(100);
    }

    public CircularQueue(int capacity) {
        this.capacity = capacity + 1;
        this.data = new Object[this.capacity];
        this.head = 0;
        this.tail = 0;
    }

    public synchronized void enqueue(Object obj) {
        if (this.next(this.tail) == this.head) {
            do {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException("Wait for queue available interrupted.", e);
                }
            } while (this.next(this.tail) == this.head);
        }
        this.data[this.tail] = obj;
        this.tail = this.next(this.tail);
        this.notifyAll();
    }

    public synchronized Object dequeue() throws InterruptedException {
        while (this.tail == this.head) {
            this.wait();
        }
        Object ret = this.data[this.head];
        this.data[this.head] = null;
        this.head = this.next(this.head);
        this.notifyAll();
        return ret;
    }

    public synchronized void waitForEmpty() throws InterruptedException {
        while (this.tail != this.head) {
            this.wait();
        }
    }

    protected final int next(int current) {
        return (current + 1) % this.capacity;
    }
}

