/*
 * Decompiled with CFR 0.152.
 */
package org.progeeks.util.thread;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReadWriteLockManager<T> {
    private final ReferenceQueue<ReadWriteLock> refQueue = new ReferenceQueue();
    private final ConcurrentMap<T, ReferenceImpl> lockMap = new ConcurrentHashMap<T, ReferenceImpl>();

    public ReadWriteLock getLock(T object) {
        ReferenceImpl ref;
        while ((ref = (ReferenceImpl)this.refQueue.poll()) != null) {
            this.lockMap.remove(ref.key, ref);
        }
        ReentrantReadWriteLock newLock = new ReentrantReadWriteLock();
        ReferenceImpl<T> newRef = new ReferenceImpl<T>(object, newLock, this.refQueue);
        ReferenceImpl<T> oldRef = null;
        while ((oldRef = this.lockMap.putIfAbsent(object, newRef)) != null) {
            ReadWriteLock oldLock = (ReadWriteLock)oldRef.get();
            if (oldLock != null) {
                newRef.clear();
                return oldLock;
            }
            this.lockMap.remove(object, oldRef);
        }
        return newLock;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ReferenceImpl<T>
    extends WeakReference<ReadWriteLock> {
        final T key;

        ReferenceImpl(T key, ReadWriteLock lock, ReferenceQueue<ReadWriteLock> refQueue) {
            super(lock, refQueue);
            this.key = key;
        }
    }
}

