/*
 * Decompiled with CFR 0.152.
 */
package org.progeeks.util.thread;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.progeeks.util.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StateCollector {
    static Log log = Log.getLog(StateCollector.class);
    private Map<Object, StateHolder> states = new HashMap<Object, StateHolder>();
    private int stateCount = 0;
    boolean interrupted = false;

    public synchronized void addActor(Object actor) {
        StateHolder stateHolder = this.states.get(actor);
        if (stateHolder != null) {
            throw new RuntimeException("Actor already exists in this collector:" + actor);
        }
        stateHolder = new StateHolder();
        this.states.put(actor, stateHolder);
        this.notifyAll();
    }

    public synchronized void removeActor(Object actor) {
        StateHolder stateHolder = this.states.remove(actor);
        if (stateHolder == null) {
            log.warn("Actor didn't exist in this collector:" + actor);
            return;
        }
        if (stateHolder.hasState) {
            --this.stateCount;
        }
        this.notifyAll();
    }

    public synchronized boolean containsActor(Object actor) {
        return this.states.containsKey(actor);
    }

    public synchronized void setState(Object actor, Object state) {
        StateHolder stateHolder = this.states.get(actor);
        if (stateHolder == null) {
            throw new RuntimeException("Actor is not a member of this collector:" + actor);
        }
        stateHolder.state = state;
        if (!stateHolder.hasState) {
            stateHolder.hasState = true;
            ++this.stateCount;
        }
        this.notifyAll();
    }

    public synchronized Object getState(Object actor) {
        StateHolder stateHolder = this.states.get(actor);
        if (stateHolder == null) {
            throw new RuntimeException("Actor is not a member of this collector:" + actor);
        }
        return stateHolder.state;
    }

    public synchronized boolean hasState(Object actor) {
        StateHolder stateHolder = this.states.get(actor);
        if (stateHolder == null) {
            throw new RuntimeException("Actor is not a member of this collector:" + actor);
        }
        return stateHolder.hasState;
    }

    public synchronized void clearState(Object actor) {
        StateHolder stateHolder = this.states.get(actor);
        if (stateHolder == null) {
            throw new RuntimeException("Actor is not a member of this collector:" + actor);
        }
        if (stateHolder.hasState) {
            stateHolder.hasState = false;
            stateHolder.state = null;
            --this.stateCount;
        }
        this.notifyAll();
    }

    public synchronized Collection<Object> getStates() {
        ArrayList<Object> list = new ArrayList<Object>();
        for (StateHolder stateHolder : this.states.values()) {
            if (!stateHolder.hasState) continue;
            list.add(stateHolder.state);
        }
        return list;
    }

    public synchronized Collection<Object> getActors() {
        return new ArrayList<Object>(this.states.keySet());
    }

    public synchronized int getStateCount() {
        return this.stateCount;
    }

    public synchronized int getActorCount() {
        return this.states.size();
    }

    public synchronized void clearAllStates() {
        for (Map.Entry<Object, StateHolder> e : this.states.entrySet()) {
            StateHolder stateHolder = e.getValue();
            stateHolder.hasState = false;
            stateHolder.state = null;
        }
        this.stateCount = 0;
        this.notifyAll();
    }

    public synchronized void clearAllActors() {
        this.states.clear();
        this.stateCount = 0;
        this.notifyAll();
    }

    public synchronized void interrupt() {
        this.interrupted = true;
        this.notifyAll();
    }

    public synchronized boolean waitForStates(double fraction, long timeout) throws InterruptedException {
        long start = System.currentTimeMillis();
        long stop = start + timeout;
        long now = System.currentTimeMillis();
        while (fraction * (double)this.states.size() > (double)this.stateCount && (timeout == 0L || now < stop) && !this.interrupted) {
            if (timeout == 0L) {
                this.wait();
            } else {
                this.wait(timeout - (now - start));
            }
            now = System.currentTimeMillis();
        }
        return !this.interrupted && (double)this.stateCount >= fraction * (double)this.states.size();
    }

    private static class StateHolder {
        Object state;
        boolean hasState;

        private StateHolder() {
        }
    }
}

