/*
 * Decompiled with CFR 0.152.
 */
package org.progeeks.util.xml;

import java.util.Collection;
import org.progeeks.util.xml.BeanObjectHandler;
import org.progeeks.util.xml.ObjectXmlReader;
import org.xml.sax.Attributes;

public class ClassObjectHandler
extends BeanObjectHandler {
    public static final ClassObjectHandler DEFAULT_CLASS_HANDLER = new ClassObjectHandler();
    public static final String CLASS_PREFIX = "class-";

    public boolean canHandle(String tag) {
        if (tag == null) {
            return false;
        }
        if ("class".equals(tag)) {
            return true;
        }
        return tag.startsWith(CLASS_PREFIX);
    }

    public void setProperty(Object obj, String field, Object value, ObjectXmlReader reader) {
        throw new UnsupportedOperationException("Class references do not support attributes.");
    }

    public void setTextProperty(Object obj, String field, String value, ObjectXmlReader reader) {
        throw new UnsupportedOperationException("Class references do not support attributes.");
    }

    public Class getPropertyClass(Object obj, String field, ObjectXmlReader reader) {
        throw new UnsupportedOperationException("Class references do not support attributes.");
    }

    public Collection getPropertyCollection(Object obj, String field, ObjectXmlReader reader) {
        throw new UnsupportedOperationException("Class references do not support attributes.");
    }

    public Object getProperty(Object obj, String field, ObjectXmlReader reader) {
        throw new UnsupportedOperationException("Class references do not support attributes.");
    }

    public Object createObject(String tag, Attributes atts, ObjectXmlReader reader) {
        if (tag.startsWith(CLASS_PREFIX)) {
            String name = tag.substring(CLASS_PREFIX.length());
            Class type = this.getTagClass(name);
            if (type == null) {
                throw new RuntimeException("Class not found:" + name);
            }
            return type;
        }
        if (atts.getValue("_ctor") != null) {
            return super.createObject("java.lang.Class", atts, reader);
        }
        return new StringBuilder();
    }

    public void setContainedText(String tag, Object obj, String text, ObjectXmlReader reader) {
        if (obj instanceof StringBuilder) {
            ((StringBuilder)obj).append(text);
            String s = obj.toString().trim();
            if (s.indexOf("\n") >= 0) {
                throw new RuntimeException("Line breaks are not supported in [" + tag + "] definitions.");
            }
        } else {
            super.setContainedText(tag, obj, text, reader);
        }
    }

    public Object resolveObject(String tag, Object obj, ObjectXmlReader reader) {
        if (obj instanceof StringBuilder) {
            String name = obj.toString().trim();
            if (name.length() == 0) {
                throw new RuntimeException("No nested class name was specified.");
            }
            Class type = this.getTagClass(name);
            if (type == null) {
                throw new RuntimeException("Class not found:" + name);
            }
            return type;
        }
        return obj;
    }
}

