/*
 * Decompiled with CFR 0.152.
 */
package org.progeeks.util.xml;

import java.util.List;
import org.progeeks.util.beans.BeanConfigurator;
import org.progeeks.util.log.Log;
import org.progeeks.util.xml.BeanConfiguratorHandler;
import org.progeeks.util.xml.ObjectXmlReader;
import org.xml.sax.Attributes;

public class ConstructedBeanHandler
extends BeanConfiguratorHandler {
    static Log log = Log.getLog(ConstructedBeanHandler.class);
    public static final String CONSTRUCT_PREFIX = "construct-";
    public static final String CONSTRUCTOR_ARGS = "ctor.arguments";

    protected String getUnprefixedName(String tag) {
        if (tag.startsWith(CONSTRUCT_PREFIX)) {
            return tag.substring(CONSTRUCT_PREFIX.length());
        }
        return null;
    }

    public boolean canHandle(String tag) {
        if (log.isDebugEnabled()) {
            log.debug("canHandle(" + tag + ")");
        }
        String cName = this.getUnprefixedName(tag);
        if (log.isDebugEnabled()) {
            log.debug("unprefixed tag:" + cName);
        }
        if (cName == null) {
            return false;
        }
        Class type = this.getTagClass(cName);
        if (log.isDebugEnabled()) {
            log.debug("tagClass:" + type);
        }
        return type != null;
    }

    public Class getPropertyClass(Object obj, String field, ObjectXmlReader reader) {
        if (CONSTRUCTOR_ARGS.equals(field)) {
            return List.class;
        }
        return super.getPropertyClass(obj, field, reader);
    }

    public Object createObject(String tag, Attributes atts, ObjectXmlReader reader) {
        String cName = this.getUnprefixedName(tag);
        Class type = this.getTagClass(cName);
        if (type == null) {
            throw new RuntimeException("Class not found:" + cName);
        }
        if (log.isDebugEnabled()) {
            log.debug("createObject() type: BeanConfigurator(" + type + ")");
        }
        BeanConfigurator bean = new BeanConfigurator(type);
        this.setObjectProperties(bean, atts, reader);
        return bean;
    }

    public Object resolveObject(String tag, Object obj, ObjectXmlReader reader) {
        BeanConfigurator factory = (BeanConfigurator)obj;
        List args = (List)factory.remove(CONSTRUCTOR_ARGS);
        Object[] argArray = new Object[args.size()];
        argArray = args.toArray(argArray);
        if (log.isDebugEnabled()) {
            StringBuffer sb = new StringBuffer("new " + factory.getBeanClass().getName() + "(");
            for (int i = 0; i < argArray.length; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(argArray[i]);
            }
            log.debug(sb);
        }
        return factory.createObject(argArray);
    }
}

