/*
 * Decompiled with CFR 0.152.
 */
package org.progeeks.util.xml;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.progeeks.util.TemplateExpressionProcessor;
import org.progeeks.util.log.Log;
import org.progeeks.util.xml.BeanObjectHandler;
import org.progeeks.util.xml.ObjectHandler;
import org.progeeks.util.xml.ObjectXmlReader;
import org.xml.sax.Attributes;

public class ExternalXmlObjectHandler
extends BeanObjectHandler {
    static Log log = Log.getLog();
    public static final String EXTERNAL_XML_OBJECT_TAG = "externalXmlObject";
    public static final String PARENT_HANDLERS_DIRECTIVE = "PARENT_HANDLERS";
    public static final String PARENT_IMPORTS_DIRECTIVE = "PARENT_IMPORTS";
    public static final String DEFAULT_XML_ENCODING = "UTF-8";
    public static final String RESOURCE_PREFIX = "resource:";

    protected Object resolvePath(String path) throws IOException {
        if (TemplateExpressionProcessor.getContextProcessor() != null) {
            Object result = TemplateExpressionProcessor.evaluateTemplateExpression(path);
            if (result instanceof CharSequence) {
                path = String.valueOf(result);
            } else {
                return result;
            }
        }
        if (path.startsWith(RESOURCE_PREFIX)) {
            URL u;
            String name = path.substring(RESOURCE_PREFIX.length());
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            if (loader == null) {
                loader = this.getClass().getClassLoader();
            }
            if ((u = loader.getResource(name)) == null) {
                throw new RuntimeException("Could not resolve class resource:" + name);
            }
            return u;
        }
        if (path.indexOf(58) > 2) {
            try {
                return new URL(path);
            }
            catch (MalformedURLException e) {
                log.info("Could not convert[" + path + "] to a URL, trying it as a file.", e);
            }
        }
        return new File(path);
    }

    protected String pathToString(Object path) {
        try {
            if (path instanceof CharSequence) {
                path = this.resolvePath(String.valueOf(path));
            }
        }
        catch (IOException e) {
            log.warn("Error converting path[" + path + "] to a string.", e);
        }
        return String.valueOf(path);
    }

    protected Reader getPathReader(Object path, String charsetName) throws IOException {
        InputStream in;
        if (charsetName == null) {
            charsetName = DEFAULT_XML_ENCODING;
        }
        if (path instanceof CharSequence) {
            path = this.resolvePath(String.valueOf(path));
        }
        if (path instanceof File) {
            in = new FileInputStream((File)path);
        } else if (path instanceof URL) {
            in = ((URL)path).openStream();
        } else {
            throw new RuntimeException("Unable to create stream for:" + path);
        }
        return new InputStreamReader(in, charsetName);
    }

    public boolean canHandle(String tag) {
        if (EXTERNAL_XML_OBJECT_TAG.equals(tag)) {
            return true;
        }
        if (PARENT_HANDLERS_DIRECTIVE.equals(tag)) {
            return true;
        }
        return PARENT_IMPORTS_DIRECTIVE.equals(tag);
    }

    public Object createObject(String tag, Attributes atts, ObjectXmlReader reader) {
        if (PARENT_HANDLERS_DIRECTIVE.equals(tag)) {
            return reader.getObjectHandlers();
        }
        if (PARENT_IMPORTS_DIRECTIVE.equals(tag)) {
            return reader.getConfigurationProperties("importPackage");
        }
        if (!EXTERNAL_XML_OBJECT_TAG.equals(tag)) {
            throw new RuntimeException("Error resolving tag to a directive, tag:" + tag);
        }
        ExternalReaderConfig bean = new ExternalReaderConfig(reader);
        this.setObjectProperties(bean, atts, reader);
        return bean;
    }

    public Object resolveObject(String tag, Object obj, ObjectXmlReader reader) {
        if (!(obj instanceof ExternalReaderConfig)) {
            return obj;
        }
        ExternalReaderConfig cfg = (ExternalReaderConfig)obj;
        try {
            Object result = cfg.resolve();
            return result;
        }
        catch (IOException e) {
            throw new RuntimeException("Error loading external object for:" + cfg.getPath());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ExternalReaderConfig {
        private ObjectXmlReader parent;
        private Object path;
        private List<ObjectHandler> handlers;
        private List<String> imports;
        private String rootTag;
        private String charsetName;

        public ExternalReaderConfig(ObjectXmlReader parent) {
            this.parent = parent;
        }

        public void setPath(Object path) {
            this.path = path;
        }

        public Object getPath() {
            return this.path;
        }

        public void setRootTag(String tag) {
            this.rootTag = tag;
        }

        public String getRootTag() {
            return this.rootTag;
        }

        public void setCharsetName(String charsetName) {
            this.charsetName = charsetName;
        }

        public String getCharsetName() {
            return this.charsetName;
        }

        protected void addExpandedValues(List target, Collection values) {
            for (Object o : values) {
                if (o instanceof Collection) {
                    this.addExpandedValues(target, (Collection)o);
                    continue;
                }
                target.add(o);
            }
        }

        public void setObjectHandlers(List<ObjectHandler> handlers) {
            this.handlers = new ArrayList<ObjectHandler>();
            this.addExpandedValues(this.handlers, handlers);
        }

        public List<ObjectHandler> getObjectHandlers() {
            return this.handlers;
        }

        public void setImports(List<String> imports) {
            this.imports = new ArrayList<String>();
            this.addExpandedValues(this.imports, imports);
        }

        public List<String> getImports() {
            return this.imports;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object resolve() throws IOException {
            ObjectXmlReader xmlReader = new ObjectXmlReader(this.rootTag);
            if (this.handlers != null) {
                xmlReader.setObjectHandlers(this.handlers);
            } else {
                xmlReader.setObjectHandlers(this.parent.getObjectHandlers());
            }
            Collection<String> c = this.imports != null ? this.imports : this.parent.getConfigurationProperties("importPackage");
            Iterator i = c.iterator();
            while (i.hasNext()) {
                xmlReader.setConfigurationProperty("importPackage", String.valueOf(i.next()));
            }
            Reader in = ExternalXmlObjectHandler.this.getPathReader(this.path, this.charsetName);
            try {
                String id = ExternalXmlObjectHandler.this.pathToString(this.path);
                Object object = xmlReader.readObject(id, in);
                return object;
            }
            finally {
                in.close();
            }
        }
    }
}

