/*
 * Decompiled with CFR 0.152.
 */
package org.progeeks.util.xml;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.progeeks.util.log.Log;
import org.progeeks.util.xml.BeanObjectHandler;
import org.progeeks.util.xml.ObjectXmlReader;
import org.xml.sax.Attributes;

public class FileSetHandler
extends BeanObjectHandler {
    static Log log = Log.getLog(FileSetHandler.class);
    private static final String FILESET_TAG = "fileset";
    private static final String INCLUDE_TAG = "include";
    private static final String EXCLUDE_TAG = "exclude";

    public boolean canHandle(String tag) {
        if (FILESET_TAG.equals(tag)) {
            return true;
        }
        if (INCLUDE_TAG.equals(tag)) {
            return true;
        }
        return EXCLUDE_TAG.equals(tag);
    }

    public Object createObject(String tag, Attributes atts, ObjectXmlReader reader) {
        Object bean = null;
        if (FILESET_TAG.equals(tag)) {
            bean = new FileSet();
        } else if (INCLUDE_TAG.equals(tag)) {
            bean = new Include();
        } else if (EXCLUDE_TAG.equals(tag)) {
            bean = new Exclude();
        } else {
            throw new RuntimeException("Illegal fileset tag:" + tag);
        }
        this.setObjectProperties(bean, atts, reader);
        return bean;
    }

    public Object resolveObject(String tag, Object obj, ObjectXmlReader reader) {
        if (obj instanceof FileSet) {
            FileSet files = (FileSet)obj;
            return files.resolveFiles();
        }
        return obj;
    }

    public static void main(String[] args) {
        Log.initialize();
        FileSet files = new FileSet();
        files.setDir(".");
        ArrayList<FilePattern> patterns = new ArrayList<FilePattern>();
        Include inc = new Include();
        inc.setName("**/*.java");
        patterns.add(inc);
        Exclude exc = new Exclude();
        exc.setName("**/util");
        patterns.add(exc);
        exc = new Exclude();
        exc.setName("test/**/*.java");
        patterns.add(exc);
        exc = new Exclude();
        exc.setName("**/meta/*/*.java");
        patterns.add(exc);
        files.setPatterns(patterns);
        List<File> l = files.resolveFiles();
        Iterator<File> i = l.iterator();
        while (i.hasNext()) {
            System.out.println("-> " + i.next());
        }
    }

    public static class Exclude
    extends FilePattern {
        public int accept(File f, File base) {
            if (this.matches(f, base, true)) {
                return -1;
            }
            return 0;
        }
    }

    public static class Include
    extends FilePattern {
        public int accept(File f, File base) {
            if (this.matches(f, base, false)) {
                return 1;
            }
            return 0;
        }
    }

    public static abstract class FilePattern {
        public static final int INCLUDE = 1;
        public static final int UNKNOWN = 0;
        public static final int EXCLUDE = -1;
        private String name;
        private Pattern pattern;

        public void setName(String name) {
            this.name = name;
            String s = this.normalizePath(name);
            this.pattern = this.createPattern(s);
        }

        public String getName() {
            return this.name;
        }

        protected String normalizePath(String path) {
            if (File.separatorChar == '\\') {
                return path.replaceAll("\\\\", "/");
            }
            return path;
        }

        protected Pattern createPattern(String name) {
            String regex = name.replaceAll("\\.", "\\\\.");
            regex = regex.replaceAll("(?<!\\*)\\*(?!\\*)", "[^/]+");
            regex = regex.replaceAll("\\*\\*", ".*");
            if (log.isDebugEnabled()) {
                log.debug("Pattern:" + name + "  compiled:" + regex);
            }
            return Pattern.compile(regex);
        }

        public abstract int accept(File var1, File var2);

        protected boolean matches(File f, File base, boolean strict) {
            Matcher m;
            String basePath = base.getPath();
            String filePath = f.getPath();
            if (filePath.startsWith(basePath) && (filePath = filePath.substring(basePath.length())).startsWith(File.separator)) {
                filePath = filePath.substring(File.separator.length());
            }
            if ((m = this.pattern.matcher(this.normalizePath(filePath))).matches()) {
                return true;
            }
            return f.isDirectory() && m.hitEnd() && !strict;
        }

        public String toString() {
            return this.getClass().getName() + "[" + this.name + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FileSet {
        private String dir;
        private FilePattern[] patterns;

        public void setDir(String dir) {
            this.dir = dir;
        }

        public String getDir() {
            return this.dir;
        }

        public void setPatterns(List<FilePattern> patternList) {
            this.patterns = new FilePattern[patternList.size()];
            this.patterns = patternList.toArray(this.patterns);
        }

        public List<FilePattern> getPatterns() {
            return Arrays.asList(this.patterns);
        }

        public List<File> resolveFiles() {
            File f = new File(this.dir);
            List<File> results = null;
            if (f.isDirectory()) {
                results = this.processDirectory(f, f);
            } else {
                if (log.isDebugEnabled()) {
                    log.debug("Adding to results:" + f);
                }
                results = new ArrayList<File>();
                results.add(f);
            }
            return results;
        }

        protected boolean accept(File f, File base) {
            int status = 0;
            for (int i = 0; i < this.patterns.length; ++i) {
                if (log.isDebugEnabled()) {
                    log.debug("       pattern:" + this.patterns[i]);
                }
                int s = this.patterns[i].accept(f, base);
                if (log.isDebugEnabled()) {
                    switch (s) {
                        case -1: {
                            log.debug("        EXCLUDE");
                            break;
                        }
                        case 1: {
                            log.debug("        INCLUDE");
                        }
                    }
                }
                if (s == -1) {
                    return false;
                }
                if (s != 1) continue;
                status = s;
            }
            return status == 1;
        }

        protected List<File> processDirectory(File d, File base) {
            if (log.isDebugEnabled()) {
                log.debug("Processing directory:" + d);
            }
            File[] files = d.listFiles();
            ArrayList<File> results = new ArrayList<File>();
            if (files != null) {
                for (int i = 0; i < files.length; ++i) {
                    if (log.isDebugEnabled()) {
                        log.debug("   checking:" + files[i]);
                    }
                    if (!this.accept(files[i], base)) continue;
                    if (files[i].isDirectory()) {
                        results.addAll(this.processDirectory(files[i], base));
                        continue;
                    }
                    results.add(files[i]);
                }
            }
            return results;
        }
    }
}

