/*
 * Decompiled with CFR 0.152.
 */
package org.progeeks.util.xml;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.progeeks.util.log.Log;
import org.progeeks.util.xml.BeanObjectHandler;
import org.progeeks.util.xml.ObjectXmlReader;
import org.xml.sax.Attributes;

public class MapObjectHandler
extends BeanObjectHandler {
    static Log log = Log.getLog(MapObjectHandler.class);

    public boolean canHandle(String tag) {
        Class clazz = this.getTagClass(tag);
        if (clazz != null && Map.class.isAssignableFrom(clazz)) {
            return true;
        }
        return "map.Entry".equals(tag);
    }

    public void setProperty(Object obj, String field, Object value, ObjectXmlReader reader) {
        if ("mapEntries".equals(field)) {
            Map map = (Map)obj;
            List entries = (List)value;
            if (entries != null) {
                for (Map.Entry entry : entries) {
                    map.put(entry.getKey(), entry.getValue());
                }
            }
        } else {
            super.setProperty(obj, field, value, reader);
        }
    }

    public Class getPropertyClass(Object obj, String field, ObjectXmlReader reader) {
        if ("mapEntries".equals(field)) {
            return Collection.class;
        }
        return super.getPropertyClass(obj, field, reader);
    }

    public Object createObject(String tag, Attributes atts, ObjectXmlReader reader) {
        if ("map.Entry".equals(tag)) {
            Entry entry = new Entry();
            this.setObjectProperties(entry, atts, reader);
            return entry;
        }
        return super.createObject(tag, atts, reader);
    }

    public static class Entry
    implements Map.Entry {
        private Object key;
        private Object value;

        public void setKey(Object key) {
            this.key = key;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object value) {
            Object oldValue = this.value;
            this.value = value;
            return oldValue;
        }
    }
}

