/*
 * Decompiled with CFR 0.152.
 */
package org.progeeks.util.xml;

import java.io.IOException;
import java.io.Reader;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.xml.transform.Transformer;
import org.progeeks.util.log.Log;
import org.progeeks.util.xml.ClassObjectHandler;
import org.progeeks.util.xml.ObjectHandler;
import org.progeeks.util.xml.PrimitiveObjectHandler;
import org.progeeks.util.xml.StringObjectHandler;
import org.progeeks.util.xml.TagReader;
import org.progeeks.util.xml.XmlException;
import org.progeeks.util.xml.XmlReader;
import org.w3c.dom.Document;
import org.xml.sax.Attributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectXmlReader
extends XmlReader {
    static Log log = Log.getLog(ObjectXmlReader.class);
    public static final String DIRECTIVE_PREFIX = "xml.";
    public static final String OID_DIRECTIVE = "xml.oid";
    public static final String REFERENCE_DIRECTIVE = "xml.ref";
    public static final String FIELD_TYPE_DIRECTIVE = "xml.type";
    public static final String COLLECTION_VALUES_DIRECTIVE = "xml.values";
    public static final String CONFIG_DIRECTIVE = "xml.config";
    public static final String PRELOAD_DIRECTIVE = "xml.preload";
    public static final String EXISTING_VALUE_DIRECTIVE = "xml.existingValue";
    public static final String PROGRESSIVE_FIELD_DIRECTIVE = "xml.progressive";
    public static final String LIST_VALUE_DIRECTIVE = "xml.listValue";
    private static final Set<String> PROPERTY_DIRECTIVE_ATTRIBUTES = new HashSet<String>();
    private static final Set<String> OBJECT_DIRECTIVE_ATTRIBUTES;
    private List<ObjectHandler> handlers = new ArrayList<ObjectHandler>();
    private Map<String, ObjectHandler> handlerMap = new HashMap<String, ObjectHandler>();
    private Map<String, Set<String>> configMap = new HashMap<String, Set<String>>();
    private Map<String, String> aliases = new HashMap<String, String>();
    private Object rootObject;
    private Map<String, Object> objectMap = new HashMap<String, Object>();
    private String rootTag = null;
    private boolean autoCreateLists = true;

    public ObjectXmlReader() {
        this(null, true);
    }

    public ObjectXmlReader(boolean addStandardHandlers) {
        this(null, addStandardHandlers);
    }

    public ObjectXmlReader(String rootTag) {
        this(rootTag, true);
    }

    public ObjectXmlReader(String rootTag, boolean addStandardHandlers) {
        this.rootTag = rootTag;
        this.setDefaultHandler(new ObjectTagReader());
        if (addStandardHandlers) {
            this.addStandardObjectHandlers();
        }
    }

    public void addStandardObjectHandlers() {
        this.addObjectHandler(StringObjectHandler.DEFAULT_STRING_HANDLER);
        this.addObjectHandler(PrimitiveObjectHandler.DEFAULT_PRIMITIVE_HANDLER);
        this.addObjectHandler(ClassObjectHandler.DEFAULT_CLASS_HANDLER);
    }

    public void setObjectHandlers(List<ObjectHandler> handlers) {
        this.handlers.clear();
        this.handlers.addAll(handlers);
    }

    public void addObjectHandler(ObjectHandler handler) {
        this.handlers.add(handler);
        this.configureHandler(handler);
    }

    public List<ObjectHandler> getObjectHandlers() {
        return this.handlers;
    }

    public void addObjectTagAlias(String objectTag, String alias) {
        this.aliases.put(objectTag, alias);
    }

    @Override
    public Object readObject(Reader in) throws IOException {
        return this.readObject(null, in);
    }

    public Object readObject(String systemId, Reader in) throws IOException {
        this.reset();
        this.readXml(systemId, in);
        return this.rootObject;
    }

    public Object readObject(Document in) throws XmlException {
        this.reset();
        this.readXml(in);
        return this.rootObject;
    }

    public Object readObject(Document in, Transformer transformer) throws XmlException {
        this.reset();
        this.readXml(in, transformer);
        return this.rootObject;
    }

    public boolean ignoreAttribute(String name) {
        return OBJECT_DIRECTIVE_ATTRIBUTES.contains(name);
    }

    public Object getReferenceObject(String id) {
        Object obj = this.objectMap.get(id);
        if (obj == null) {
            return null;
        }
        if (!(obj instanceof ObjectReference)) {
            throw this.createXmlException("Format error: something got out of whack somewhere.");
        }
        return ((ObjectReference)obj).object;
    }

    @Override
    protected void reset() {
        super.reset();
        this.objectMap.clear();
        this.rootObject = null;
    }

    protected ObjectHandler getHandler(String tag) {
        ObjectHandler handler = this.handlerMap.get(tag);
        if (handler != null) {
            return handler;
        }
        for (ObjectHandler h : this.handlers) {
            if (log.isDebugEnabled()) {
                log.debug("Checking handler:" + h + "  to handle tag:" + tag);
            }
            if (!h.canHandle(tag)) continue;
            handler = h;
            break;
        }
        this.handlerMap.put(tag, handler);
        return handler;
    }

    protected Set<String> getConfigurationProperties(String key, boolean create) {
        Set<String> props = this.configMap.get(key);
        if (props == null && create) {
            props = new LinkedHashSet<String>();
            this.configMap.put(key, props);
        }
        return props;
    }

    protected void configureHandlers(Attributes atts) {
        for (int j = 0; j < atts.getLength(); ++j) {
            this.setConfigurationProperty(atts.getQName(j), atts.getValue(j));
        }
    }

    public void setConfigurationProperty(String name, String value) {
        this.getConfigurationProperties(name, true).add(value);
        for (ObjectHandler h : this.handlers) {
            h.setConfigurationProperty(name, value);
        }
    }

    public Set<String> getConfigurationProperties(String name) {
        Set<String> props = this.getConfigurationProperties(name, false);
        if (props == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(props);
    }

    public Set getConfigurationPropertyNames() {
        return Collections.unmodifiableSet(this.configMap.keySet());
    }

    protected Map getConfigurationMap() {
        return this.configMap;
    }

    protected void configureHandler(ObjectHandler handler) {
        for (Map.Entry<String, Set<String>> e : this.configMap.entrySet()) {
            String name = e.getKey();
            Set<String> props = e.getValue();
            if (props == null) continue;
            for (String value : props) {
                handler.setConfigurationProperty(name, value);
            }
        }
    }

    static {
        PROPERTY_DIRECTIVE_ATTRIBUTES.add(REFERENCE_DIRECTIVE);
        PROPERTY_DIRECTIVE_ATTRIBUTES.add(FIELD_TYPE_DIRECTIVE);
        PROPERTY_DIRECTIVE_ATTRIBUTES.add(PROGRESSIVE_FIELD_DIRECTIVE);
        PROPERTY_DIRECTIVE_ATTRIBUTES.add(LIST_VALUE_DIRECTIVE);
        PROPERTY_DIRECTIVE_ATTRIBUTES.add("progressive");
        PROPERTY_DIRECTIVE_ATTRIBUTES.add("listValue");
        OBJECT_DIRECTIVE_ATTRIBUTES = new HashSet<String>();
        OBJECT_DIRECTIVE_ATTRIBUTES.add(OID_DIRECTIVE);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CollectionField
    extends AbstractCollection<Object>
    implements FieldValue {
        String name;
        Collection<Object> value;

        public CollectionField(String name, Class type) {
            this.name = name;
            this.value = SortedSet.class.isAssignableFrom(type) ? new TreeSet<Object>() : (Set.class.isAssignableFrom(type) ? new HashSet<Object>() : new ArrayList<Object>());
        }

        public static boolean canHandle(Class<?> type) {
            if (type.isAssignableFrom(ArrayList.class)) {
                return true;
            }
            if (type.isAssignableFrom(HashSet.class)) {
                return true;
            }
            if (type.isAssignableFrom(TreeSet.class)) {
                return true;
            }
            if (type.isAssignableFrom(Collection.class)) {
                return true;
            }
            return type.isAssignableFrom(Iterable.class);
        }

        @Override
        public boolean isSet() {
            return true;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Object getValue() {
            return this.value;
        }

        @Override
        public boolean add(Object obj) {
            return this.value.add(obj);
        }

        @Override
        public Iterator<Object> iterator() {
            return this.value.iterator();
        }

        @Override
        public int size() {
            return this.value.size();
        }
    }

    private static class ObjectField
    implements FieldValue {
        String name;
        Object value;
        Class type;
        boolean set;

        public ObjectField(String name, Class type) {
            this.name = name;
            this.type = type;
        }

        public String getName() {
            return this.name;
        }

        public void setValue(Object value) {
            this.value = value;
            this.set = true;
        }

        public Object getValue() {
            return this.value;
        }

        public Class getFieldType() {
            return this.type;
        }

        public boolean isSet() {
            return this.set;
        }
    }

    private static interface FieldValue {
        public String getName();

        public Object getValue();

        public boolean isSet();
    }

    private static class ObjectReference {
        ObjectHandler handler;
        Object object;
        boolean resolved = false;

        public ObjectReference(ObjectHandler handler, Object object) {
            this.handler = handler;
            this.object = object;
        }
    }

    protected class ObjectTagReader
    extends TagReader {
        protected ObjectTagReader() {
        }

        public Object tagStart(String tag, Attributes atts, Object current) throws XmlException {
            if (ObjectXmlReader.this.rootTag != null && current == null && ObjectXmlReader.this.getStackSize() == 0) {
                if (log.isInfoEnabled()) {
                    log.info("Processing pre-configured root tag:" + ObjectXmlReader.this.rootTag);
                }
                if (!tag.equals(ObjectXmlReader.this.rootTag)) {
                    throw new XmlException("Error root tag is invalid:" + tag);
                }
                if (ObjectXmlReader.this.rootObject != null) {
                    throw ObjectXmlReader.this.createXmlException("Root tag encountered twice.");
                }
                ObjectXmlReader.this.rootObject = new ArrayList();
                return ObjectXmlReader.this.rootObject;
            }
            if (ObjectXmlReader.CONFIG_DIRECTIVE.equals(tag)) {
                return this.processConfigDirective(atts);
            }
            if (ObjectXmlReader.PRELOAD_DIRECTIVE.equals(tag)) {
                return this.processPreloadDirective(atts);
            }
            if (current instanceof ObjectReference && this.detectField(tag, atts, (ObjectReference)current)) {
                return this.processField(tag, atts, current);
            }
            if (ObjectXmlReader.REFERENCE_DIRECTIVE.equals(tag)) {
                return this.processReferenceDirective(atts);
            }
            if (ObjectXmlReader.EXISTING_VALUE_DIRECTIVE.equals(tag)) {
                return this.processExistingValueDirective(atts, current);
            }
            return this.processValue(tag, atts, current);
        }

        protected Object processConfigDirective(Attributes atts) {
            ObjectXmlReader.this.configureHandlers(atts);
            return null;
        }

        protected Object processPreloadDirective(Attributes atts) {
            return new ArrayList();
        }

        protected boolean detectField(String tag, Attributes atts, ObjectReference ref) {
            if (!(ref.object instanceof Collection)) {
                return true;
            }
            if (ObjectXmlReader.COLLECTION_VALUES_DIRECTIVE.equals(tag)) {
                return true;
            }
            if (ObjectXmlReader.REFERENCE_DIRECTIVE.equals(tag)) {
                return false;
            }
            if (ObjectXmlReader.EXISTING_VALUE_DIRECTIVE.equals(tag)) {
                return false;
            }
            if (atts.getValue(ObjectXmlReader.FIELD_TYPE_DIRECTIVE) != null) {
                return true;
            }
            if (atts.getValue(ObjectXmlReader.PROGRESSIVE_FIELD_DIRECTIVE) != null) {
                return true;
            }
            if (atts.getValue(ObjectXmlReader.LIST_VALUE_DIRECTIVE) != null) {
                return true;
            }
            if (atts.getValue("progressive") != null || atts.getValue("listValue") != null) {
                return true;
            }
            return ref.handler.isPropertyMutable(ref.object, tag, ObjectXmlReader.this);
        }

        protected Object processField(String tag, Attributes atts, Object current) {
            ObjectReference ref = (ObjectReference)current;
            if (tag.equals(ObjectXmlReader.COLLECTION_VALUES_DIRECTIVE)) {
                if (!Collection.class.isAssignableFrom(ref.object.getClass())) {
                    throw ObjectXmlReader.this.createXmlException("xml.values special tag cannot be applied to:" + ref.object);
                }
                if (atts.getLength() > 0) {
                    throw ObjectXmlReader.this.createXmlException("Attributes are not allowed for tag[" + tag + "]:" + XmlReader.getAttributesAsMap(atts));
                }
                return ref.object;
            }
            if (atts.getValue(ObjectXmlReader.REFERENCE_DIRECTIVE) != null) {
                String oid = atts.getValue(ObjectXmlReader.REFERENCE_DIRECTIVE);
                ObjectReference oidRef = (ObjectReference)ObjectXmlReader.this.objectMap.get(oid);
                if (oidRef == null || oidRef.object == null) {
                    throw ObjectXmlReader.this.createXmlException("Reference not found for object ID:" + oid);
                }
                ref.handler.setProperty(ref.object, tag, oidRef.object, ObjectXmlReader.this);
                if (atts.getLength() > 1) {
                    Map<String, String> bad = XmlReader.getAttributesAsMap(atts);
                    bad.remove(ObjectXmlReader.REFERENCE_DIRECTIVE);
                    throw ObjectXmlReader.this.createXmlException(atts.getLength() - 1 + " unprocessed attributes for tag[" + tag + "]:" + bad);
                }
                return null;
            }
            Class type = null;
            Map<String, String> unusedAtts = XmlReader.getAttributesAsMap(atts);
            if (atts.getValue(ObjectXmlReader.FIELD_TYPE_DIRECTIVE) != null) {
                unusedAtts.remove(ObjectXmlReader.FIELD_TYPE_DIRECTIVE);
                try {
                    type = Class.forName(atts.getValue(ObjectXmlReader.FIELD_TYPE_DIRECTIVE));
                }
                catch (ClassNotFoundException e) {
                    log.warn("Field type override class not found", e);
                }
            }
            if (type == null) {
                type = ref.handler.getPropertyClass(ref.object, tag, ObjectXmlReader.this);
            }
            if (type == null) {
                throw ObjectXmlReader.this.createXmlException("Field[" + tag + "] not found in object:" + ref.object);
            }
            if (Iterable.class.isAssignableFrom(type)) {
                String listValue;
                unusedAtts.remove(ObjectXmlReader.PROGRESSIVE_FIELD_DIRECTIVE);
                unusedAtts.remove(ObjectXmlReader.LIST_VALUE_DIRECTIVE);
                unusedAtts.remove("progressive");
                unusedAtts.remove("listValue");
                String progressive = atts.getValue(ObjectXmlReader.PROGRESSIVE_FIELD_DIRECTIVE);
                if (progressive == null && (progressive = atts.getValue("progressive")) != null) {
                    log.warn("Attribute 'progressive' has been deprecated, use 'xml.progressive' instead:" + ObjectXmlReader.this.getLocation());
                }
                if ((listValue = atts.getValue(ObjectXmlReader.LIST_VALUE_DIRECTIVE)) == null && (listValue = atts.getValue("listValue")) != null) {
                    log.warn("Attribute 'listValue' has been deprecated, use 'xml.listValue' instead:" + ObjectXmlReader.this.getLocation());
                }
                if ("true".equalsIgnoreCase(progressive)) {
                    if (!unusedAtts.isEmpty()) {
                        throw ObjectXmlReader.this.createXmlException("Invalid attributes for tag[" + tag + "]:" + unusedAtts);
                    }
                    return ref.handler.getPropertyCollection(ref.object, tag, ObjectXmlReader.this);
                }
                if ("true".equalsIgnoreCase(listValue)) {
                    if (!unusedAtts.isEmpty()) {
                        throw ObjectXmlReader.this.createXmlException("Invalid attributes for tag[" + tag + "]:" + unusedAtts);
                    }
                    return new ObjectField(tag, type);
                }
                if (CollectionField.canHandle(type)) {
                    if (!unusedAtts.isEmpty()) {
                        throw ObjectXmlReader.this.createXmlException("Invalid attributes for tag[" + tag + "]:" + unusedAtts);
                    }
                    return new CollectionField(tag, type);
                }
                if (!unusedAtts.isEmpty()) {
                    throw ObjectXmlReader.this.createXmlException("Invalid attributes for tag[" + tag + "]:" + unusedAtts);
                }
                return new ObjectField(tag, type);
            }
            if (!unusedAtts.isEmpty()) {
                throw ObjectXmlReader.this.createXmlException("Invalid attributes for tag[" + tag + "]:" + unusedAtts);
            }
            return new ObjectField(tag, type);
        }

        protected Object processReferenceDirective(Attributes atts) {
            String id = atts.getValue("oid");
            Object obj = ObjectXmlReader.this.objectMap.get(id);
            if (obj == null) {
                throw ObjectXmlReader.this.createXmlException("Reference not found for object ID:" + id);
            }
            if (atts.getLength() > 1) {
                throw ObjectXmlReader.this.createXmlException("Attributes other than oid are not supported on references.");
            }
            if (!(obj instanceof ObjectReference)) {
                throw ObjectXmlReader.this.createXmlException("Format error: something got out of whack somewhere.");
            }
            return obj;
        }

        protected Object processExistingValueDirective(Attributes atts, Object current) {
            if (current instanceof FieldValue) {
                ObjectReference parent = (ObjectReference)ObjectXmlReader.this.getPreviousObject();
                String fieldName = ((FieldValue)current).getName();
                Object obj = parent.handler.getProperty(parent.object, fieldName, ObjectXmlReader.this);
                if (obj == null) {
                    throw ObjectXmlReader.this.createXmlException("xml.existingValue property:" + fieldName + " in " + parent.object + " cannot be null.");
                }
                ObjectReference ref = new ObjectReference(parent.handler, obj);
                if (atts.getValue(ObjectXmlReader.OID_DIRECTIVE) != null) {
                    if (log.isDebugEnabled()) {
                        log.debug("Caching id:" + atts.getValue(ObjectXmlReader.OID_DIRECTIVE) + "  value:" + ref);
                    }
                    ObjectXmlReader.this.objectMap.put(atts.getValue(ObjectXmlReader.OID_DIRECTIVE), ref);
                }
                return ref;
            }
            throw new RuntimeException("Incompatible existingValue nesting.");
        }

        protected Object processValue(String tag, Attributes atts, Object current) {
            String alias = (String)ObjectXmlReader.this.aliases.get(tag);
            if (alias != null) {
                tag = alias;
            }
            boolean autonested = current instanceof ObjectReference;
            ObjectHandler handler = ObjectXmlReader.this.getHandler(tag);
            if (handler == null) {
                String msg = "Cannot create object from tag[" + tag + "].";
                msg = autonested ? msg + " Either this was a misinterpretted field reference for parent type[" + ((ObjectReference)current).object.getClass() + "]" + " or a proper XML ObjectHandler was not found." : msg + " A proper XML ObjectHandler was not found.";
                throw ObjectXmlReader.this.createXmlException(msg);
            }
            if (log.isDebugEnabled()) {
                log.debug("Using handler:" + handler + "  for tag:" + tag);
            }
            Object obj = handler.createObject(tag, atts, ObjectXmlReader.this);
            ObjectReference ref = new ObjectReference(handler, obj);
            if (atts.getValue(ObjectXmlReader.OID_DIRECTIVE) != null) {
                if (log.isDebugEnabled()) {
                    log.debug("Caching id:" + atts.getValue(ObjectXmlReader.OID_DIRECTIVE) + "  value:" + ref);
                }
                ObjectXmlReader.this.objectMap.put(atts.getValue(ObjectXmlReader.OID_DIRECTIVE), ref);
            }
            return ref;
        }

        public void tagText(String tag, String text, StringBuffer buffer, Object parent, Object tagObject) throws XmlException {
            if (tagObject instanceof ObjectReference) {
                ObjectReference ref = (ObjectReference)tagObject;
                ref.handler.setContainedText(tag, ref.object, text, ObjectXmlReader.this);
            } else {
                super.tagText(tag, text, buffer, parent, tagObject);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void tagEnd(String tag, String text, Object parent, Object tagObject) throws XmlException {
            if (log.isDebugEnabled()) {
                log.debug("Stack depth:" + ObjectXmlReader.this.getStackSize() + "   tag end:" + tag);
            }
            if (ObjectXmlReader.CONFIG_DIRECTIVE.equals(tag) || ObjectXmlReader.PRELOAD_DIRECTIVE.equals(tag)) return;
            if (tagObject instanceof ObjectReference) {
                ObjectReference ref = (ObjectReference)tagObject;
                if (!ref.resolved) {
                    ref.object = ref.handler.resolveObject(tag, ref.object, ObjectXmlReader.this);
                    ref.resolved = true;
                }
                if (parent instanceof Collection) {
                    ((Collection)parent).add(ref.object);
                    return;
                } else if (parent instanceof ObjectField) {
                    ObjectField f = (ObjectField)parent;
                    if (f.isSet()) {
                        if (ObjectXmlReader.this.autoCreateLists && f.getFieldType().isAssignableFrom(ArrayList.class)) {
                            CollectionField newField = new CollectionField(tag, f.getFieldType());
                            newField.add(f.getValue());
                            newField.add(ref.object);
                            ObjectXmlReader.this.replaceCurrentObject(newField);
                            return;
                        }
                        log.warn("Property[" + f.getName() + "] at:" + ObjectXmlReader.this.getLocation() + " has already been set once in this context.");
                    }
                    f.setValue(ref.object);
                    return;
                } else if (parent instanceof ObjectReference && ((ObjectReference)parent).object instanceof Collection) {
                    ObjectReference parentRef = (ObjectReference)parent;
                    log.debug("Adding tag object directly to collection parent, tag object type:" + tagObject.getClass());
                    ((Collection)parentRef.object).add(ref.object);
                    return;
                } else {
                    if (ObjectXmlReader.this.getStackSize() != 0 || ObjectXmlReader.this.rootObject != null) throw ObjectXmlReader.this.createXmlException("Format error, tag type invalid for this context:" + tag);
                    log.debug("Making tag object the root bean  type:" + tagObject.getClass());
                    ObjectXmlReader.this.rootObject = ref.object;
                }
                return;
            } else if (parent instanceof ObjectReference) {
                if (!(tagObject instanceof FieldValue)) return;
                ObjectReference ref = (ObjectReference)parent;
                FieldValue val = (FieldValue)tagObject;
                if (text.length() > 0 && !val.isSet()) {
                    ref.handler.setTextProperty(ref.object, tag, text, ObjectXmlReader.this);
                    return;
                } else if (!val.isSet()) {
                    ref.handler.setTextProperty(ref.object, tag, text, ObjectXmlReader.this);
                    return;
                } else {
                    if (text.trim().length() > 0) {
                        log.warn("Nested text ignored in tag [" + tag + "] because nested elements were defined.  Text:" + text);
                    }
                    ref.handler.setProperty(ref.object, tag, val.getValue(), ObjectXmlReader.this);
                }
                return;
            } else {
                if (parent == null) return;
                throw new RuntimeException("XML processing error.  Unhandled path in tag end code.");
            }
        }
    }
}

