/*
 * Decompiled with CFR 0.152.
 */
package org.progeeks.util.xml;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.progeeks.util.Inspector;
import org.progeeks.util.xml.AbstractObjectHandler;
import org.progeeks.util.xml.ObjectXmlReader;
import org.xml.sax.Attributes;

public class PrimitiveObjectHandler
extends AbstractObjectHandler {
    public static final PrimitiveObjectHandler DEFAULT_PRIMITIVE_HANDLER = new PrimitiveObjectHandler();
    public static final String ARRAY_MARKER = "array-";
    public static Map<String, Class> handledTags = new HashMap<String, Class>();

    public boolean canHandle(String tag) {
        return handledTags.keySet().contains(tag);
    }

    protected Class getTagClass(String tag) {
        return handledTags.get(tag);
    }

    public void setProperty(Object obj, String field, Object value, ObjectXmlReader reader) {
        throw new UnsupportedOperationException("Primitives do not support attributes.");
    }

    public void setTextProperty(Object obj, String field, String value, ObjectXmlReader reader) {
        throw new UnsupportedOperationException("Primitives do not support attributes.");
    }

    public Class getPropertyClass(Object obj, String field, ObjectXmlReader reader) {
        throw new UnsupportedOperationException("Primitives do not support attributes.");
    }

    public Collection getPropertyCollection(Object obj, String field, ObjectXmlReader reader) {
        throw new UnsupportedOperationException("Primitives do not support attributes.");
    }

    public Object getProperty(Object obj, String field, ObjectXmlReader reader) {
        throw new UnsupportedOperationException("Primitives do not support attributes.");
    }

    public Object createObject(String tag, Attributes atts, ObjectXmlReader reader) {
        Class type = this.getTagClass(tag);
        if (type == null) {
            throw new RuntimeException("Tag does not map to a primitive type:" + tag);
        }
        String s = atts.getValue("_ctor");
        if (s != null) {
            return Inspector.constructFromString(s, type);
        }
        return new StringBuilder();
    }

    public void setContainedText(String tag, Object obj, String text, ObjectXmlReader reader) {
        if (obj instanceof StringBuilder) {
            ((StringBuilder)obj).append(text);
            String s = obj.toString().trim();
            if (s.indexOf("\n") >= 0) {
                throw new RuntimeException("Line breaks are not supported in [" + tag + "] definitions.");
            }
        } else {
            super.setContainedText(tag, obj, text, reader);
        }
    }

    public Object resolveObject(String tag, Object obj, ObjectXmlReader reader) {
        if (obj instanceof StringBuilder) {
            String s = obj.toString().trim();
            Class type = this.getTagClass(tag);
            obj = Inspector.constructFromString(s, type);
        }
        return obj;
    }

    static {
        handledTags.putAll(Inspector.getPrimitiveMap());
        handledTags.put("integer", Integer.class);
        handledTags.put(ARRAY_MARKER + Boolean.TYPE.getName(), boolean[].class);
        handledTags.put(ARRAY_MARKER + Byte.TYPE.getName(), byte[].class);
        handledTags.put(ARRAY_MARKER + Character.TYPE.getName(), char[].class);
        handledTags.put(ARRAY_MARKER + Double.TYPE.getName(), double[].class);
        handledTags.put(ARRAY_MARKER + Float.TYPE.getName(), float[].class);
        handledTags.put(ARRAY_MARKER + Integer.TYPE.getName(), int[].class);
        handledTags.put("array-integer", int[].class);
        handledTags.put(ARRAY_MARKER + Long.TYPE.getName(), long[].class);
        handledTags.put(ARRAY_MARKER + Short.TYPE.getName(), short[].class);
    }
}

