/*
 * Decompiled with CFR 0.152.
 */
package org.progeeks.util.xml;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.progeeks.util.Inspector;
import org.progeeks.util.log.Log;
import org.progeeks.util.xml.BeanObjectHandler;
import org.progeeks.util.xml.ObjectXmlReader;
import org.xml.sax.Attributes;

public class SystemPropertyObjectHandler
extends BeanObjectHandler {
    static Log log = Log.getLog(SystemPropertyObjectHandler.class);
    private static final String OLD_PROPERTY_DIRECTIVE = "property:";
    private static final String PROPERTY_DIRECTIVE = "property-";
    private static final String TYPE_STRING = "string";
    private static final String TYPE_FLOAT = "float";
    private static final String TYPE_DOUBLE = "double";
    private static final String TYPE_INTEGER = "integer";
    private static final String TYPE_LONG = "long";
    private static final String TYPE_BOOLEAN = "boolean";
    private static final String TYPE_OBJECT = "object";
    private static final Map<String, Class> BASE_TYPES = new HashMap<String, Class>();
    private Properties defaultProperties;

    public void setDefaultProperties(Properties props) {
        this.defaultProperties = props;
    }

    public Properties getDefaultProperties() {
        return this.defaultProperties;
    }

    protected String getProperty(String key) {
        return this.getProperty(key, null);
    }

    protected String getProperty(String key, String defaultValue) {
        if (key == null) {
            throw new RuntimeException("Property key not set.");
        }
        String value = System.getProperty(key);
        if (value != null) {
            if (log.isDebugEnabled()) {
                log.debug("Using system property[" + key + "] = [" + value + "]");
            }
            return value;
        }
        if (this.defaultProperties != null && (value = this.defaultProperties.getProperty(key)) != null) {
            if (log.isDebugEnabled()) {
                log.debug("Using default property[" + key + "] = [" + value + "]");
            }
            return value;
        }
        return defaultValue;
    }

    public boolean canHandle(String tag) {
        String type;
        if (!tag.startsWith(PROPERTY_DIRECTIVE) && !tag.startsWith(OLD_PROPERTY_DIRECTIVE)) {
            return false;
        }
        if (tag.startsWith(OLD_PROPERTY_DIRECTIVE)) {
            log.warn("XML uses deprecated 'property:' instead of 'property-'.");
        }
        if (BASE_TYPES.containsKey(type = tag.substring(PROPERTY_DIRECTIVE.length()))) {
            return true;
        }
        if (TYPE_OBJECT.equals(type)) {
            return true;
        }
        log.error("Unknown system property reference type:" + type + " in tag:" + tag);
        return false;
    }

    public Object createObject(String tag, Attributes atts, ObjectXmlReader reader) {
        SystemPropertyHolder bean;
        String type;
        if (!tag.startsWith(PROPERTY_DIRECTIVE) && !tag.startsWith(OLD_PROPERTY_DIRECTIVE)) {
            throw new RuntimeException("Illegal system property reference:" + tag);
        }
        if (tag.startsWith(OLD_PROPERTY_DIRECTIVE)) {
            log.warn("XML uses deprecated 'property:' instead of 'property-'.");
        }
        if (TYPE_OBJECT.equals(type = tag.substring(PROPERTY_DIRECTIVE.length()))) {
            bean = new ObjectPropertyHolder();
        } else {
            Class c = BASE_TYPES.get(type);
            if (c == null) {
                throw new RuntimeException("Unknown system property reference type:" + type + " in tag:" + tag);
            }
            bean = new SystemPropertyHolder(c);
        }
        this.setObjectProperties(bean, atts, reader);
        return bean;
    }

    public Object resolveObject(String tag, Object obj, ObjectXmlReader reader) {
        SystemPropertyHolder holder = (SystemPropertyHolder)obj;
        return holder.resolve();
    }

    static {
        BASE_TYPES.put(TYPE_STRING, String.class);
        BASE_TYPES.put(TYPE_FLOAT, Float.class);
        BASE_TYPES.put(TYPE_DOUBLE, Double.class);
        BASE_TYPES.put(TYPE_INTEGER, Integer.class);
        BASE_TYPES.put(TYPE_LONG, Long.class);
        BASE_TYPES.put(TYPE_BOOLEAN, Boolean.class);
    }

    public class ObjectPropertyHolder
    extends SystemPropertyHolder {
        public void setType(Class type) {
            super.setType(type);
        }

        public Class getType() {
            return super.getType();
        }
    }

    public class SystemPropertyHolder {
        private Class type;
        private String key;
        private Object defaultValue = null;

        public SystemPropertyHolder(Class type) {
            this.type = type;
        }

        protected SystemPropertyHolder() {
        }

        protected void setType(Class type) {
            this.type = type;
            if (this.defaultValue instanceof String) {
                this.setDefaultValue((String)this.defaultValue);
            }
        }

        protected Class getType() {
            return this.type;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }

        public void setDefaultValue(String value) {
            if (this.type == null) {
                this.defaultValue = value;
                return;
            }
            this.defaultValue = Inspector.constructFromString(value, this.type);
            if (this.defaultValue == null) {
                log.warn("null returned turning default value: [" + value + "] into a " + this.type.getName());
            }
        }

        public Object getDefaultValue() {
            return this.defaultValue;
        }

        public Object resolve() {
            if (this.type == null) {
                throw new RuntimeException("No type has been defined for property:" + this.getKey());
            }
            String value = SystemPropertyObjectHandler.this.getProperty(this.getKey());
            if (value == null) {
                if (this.defaultValue == null && !String.class.equals((Object)this.type)) {
                    throw new RuntimeException("System property " + this.key + " is not set and no default value is specified.");
                }
                Object result = this.getDefaultValue();
                if (log.isDebugEnabled()) {
                    log.debug("Using defaultValue[" + result + "] for key[" + this.getKey() + "]");
                }
                return result;
            }
            Object result = Inspector.constructFromString(value, this.type);
            if (log.isDebugEnabled()) {
                log.debug("Using value[" + result + "] for key[" + this.getKey() + "]");
            }
            if (result != null) {
                return result;
            }
            log.warn("null returned turning value: [" + value + "] into a " + this.type.getName());
            if (this.defaultValue == null) {
                throw new RuntimeException("Could not parse system property " + this.key + " and no default value is specified.");
            }
            if (log.isDebugEnabled()) {
                log.debug("Using defaultValue[" + this.defaultValue + "] for key[" + this.getKey() + "]");
            }
            return this.defaultValue;
        }
    }
}

