/*
 * Decompiled with CFR 0.152.
 */
package org.progeeks.util.xml;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.progeeks.util.IndentPrintWriter;

public class XmlPrintWriter
extends IndentPrintWriter {
    private List<String> tags = new LinkedList<String>();
    private static final int CTX_BODY = 0;
    private static final int CTX_TAG = 1;
    private static final int CTX_COMMENT = 2;
    private static final int CTX_DATA = 3;
    private static final int CTX_PROCESSING_INSTRUCTION = 4;
    private static final int CTX_DOCTYPE = 5;
    private static final int CTX_DOCTYPE_BLOCK = 6;
    private static final int CTX_MARKUP_DECLARATION = 7;
    private static final int CTX_RAW = 8;
    private static final int ENCODE_NORMAL = 0;
    private static final int ENCODE_RAW = 1;
    private static final int ENCODE_QUOTED = 2;
    private static final int ENCODE_SINGLE_QUOTED = 3;
    private int context = 0;
    private int encoding = 0;
    private String openTag = null;
    private boolean hasAttributes = false;
    private boolean singleTag = false;
    private Map<String, String> nextAttributes = new LinkedHashMap<String, String>();
    private boolean singleLineAttributes = false;

    public XmlPrintWriter(Writer out) {
        super(out);
    }

    public void setSingleLineAttributes(boolean flag) {
        this.singleLineAttributes = flag;
    }

    public boolean getSingleLineAttributes() {
        return this.singleLineAttributes;
    }

    public void pushTag(String tag) {
        this.closeBlock();
        if (!this.isNewLine()) {
            this.endLine();
        }
        this.tags.add(0, tag);
        this.printBypass("<" + tag);
        this.context = 1;
        this.openTag = tag;
        this.printPushedAttributes();
    }

    public void printTag(String tag) {
        this.closeBlock();
        if (!this.isNewLine()) {
            this.endLine();
        }
        this.printBypass("<" + tag);
        this.context = 1;
        this.singleTag = true;
        this.openTag = tag;
        this.printPushedAttributes();
    }

    public void printProcessingInstruction(String target) {
        this.closeBlock();
        if (!this.isNewLine()) {
            this.endLine();
        }
        this.printBypass("<?" + target + " ");
        this.context = 4;
        this.pushIndent();
    }

    public void closeProcessingInstruction() {
        if (this.context != 4) {
            return;
        }
        this.printlnBypass("?>");
        this.context = 0;
        this.hasAttributes = false;
        this.popIndent();
    }

    public void printAttribute(String name, String value) {
        if (value == null) {
            return;
        }
        if (this.context != 1 && this.context != 4) {
            throw new IllegalStateException("No open tags to receive attributes.");
        }
        if (!this.hasAttributes && this.context != 4) {
            this.printBypass(" ");
        }
        if (this.singleLineAttributes) {
            super.println();
            this.printBypass("        ".substring(0, Math.min(8, this.openTag.length() + 1)));
        }
        if (this.context == 1) {
            this.printBypass(name + "=\"");
            this.encoding = 2;
            this.writeEncoded(value, 0, value.length());
            this.encoding = 0;
            this.printBypass("\" ");
        } else {
            this.printBypass(name + "='");
            this.encoding = 2;
            this.writeEncoded(value, 0, value.length());
            this.encoding = 0;
            this.printBypass("' ");
        }
        this.hasAttributes = true;
    }

    public void pushAttribute(String name, String value) {
        if (value == null) {
            return;
        }
        this.nextAttributes.put(name, value);
    }

    public void clearPushedAttributes() {
        this.nextAttributes.clear();
    }

    protected void printPushedAttributes() {
        for (Map.Entry<String, String> entry : this.nextAttributes.entrySet()) {
            this.printAttribute(entry.getKey(), entry.getValue());
        }
        this.nextAttributes.clear();
    }

    public String popTag() {
        if (this.tags.size() == 0) {
            throw new IllegalStateException("Tag stack is empty.");
        }
        String tag = this.tags.remove(0);
        if (this.context == 1 && this.openTag == tag) {
            this.singleTag = true;
            this.closeBlock();
        } else {
            this.closeBlock();
            this.popIndent();
            this.printlnBypass("</" + tag + ">");
        }
        return tag;
    }

    public void popTag(String tag) {
        while (!tag.equals(this.popTag())) {
        }
    }

    public void startDocType(String root, String systemLiteral, String publicId) {
        this.closeBlock();
        if (!this.isNewLine()) {
            this.endLine();
        }
        this.tags.add(0, "!DOCTYPE");
        this.printBypass("<!DOCTYPE " + root);
        this.pushIndent();
        if (systemLiteral != null) {
            this.endLine();
            if (publicId != null) {
                this.printBypass(" PUBLIC \"" + publicId + "\"");
                this.endLine();
                this.printBypass("\"" + systemLiteral + "\"");
            } else {
                this.printBypass(" SYSTEM \"" + systemLiteral + "\"");
            }
        }
        this.context = 5;
    }

    public void closeDocType() {
        if (this.context == 7) {
            this.closeMarkupDeclaration();
        }
        if (this.context != 5 && this.context != 6) {
            throw new IllegalStateException("DOCTYPE element not open.");
        }
        this.popIndent();
        String tag = this.tags.remove(0);
        if (this.context == 6) {
            this.printBypass("]");
        }
        this.printlnBypass(">");
        this.context = 0;
    }

    public void startMarkupDeclaration(String markup) {
        switch (this.context) {
            case 5: {
                this.printlnBypass(" [");
                this.context = 6;
                break;
            }
            case 6: {
                break;
            }
            default: {
                this.closeBlock();
            }
        }
        this.printBypass("<!ENTITY ");
        this.pushIndent();
        this.context = 7;
    }

    public void closeMarkupDeclaration() {
        if (this.context != 7) {
            throw new IllegalStateException("Markup declaration element not open.");
        }
        this.printlnBypass(">");
        this.popIndent();
        this.context = "!DOCTYPE".equals(this.tags.get(0)) ? 6 : 0;
    }

    public int getTagStackDepth() {
        return this.tags.size();
    }

    public void printComment(String comment) {
        this.startComment();
        this.printBypass(comment);
        this.closeComment();
    }

    public void startComment() {
        this.closeBlock();
        this.printBypass("<!-- ");
        this.context = 2;
        this.pushIndent("     ");
    }

    public void closeComment() {
        if (this.context != 2) {
            return;
        }
        this.popIndent();
        this.printlnBypass(" -->");
        this.context = 0;
    }

    public void startDataBlock() {
        this.closeBlock();
        this.setOverrideIndent(true);
        this.encoding = 1;
        this.printBypass("<![CDATA[");
        this.context = 3;
    }

    public void closeDataBlock() {
        if (this.context != 3) {
            return;
        }
        this.printBypass("]]>");
        this.encoding = 0;
        this.setOverrideIndent(false);
        this.context = 0;
    }

    public void printRawText(String comment) {
        this.startRawText();
        this.printBypass(comment);
        this.closeRawText();
    }

    public void startRawText() {
        this.closeBlock();
        this.setOverrideIndent(true);
        this.context = 8;
        this.encoding = 1;
    }

    public void closeRawText() {
        if (this.context != 8) {
            return;
        }
        this.printlnBypass("");
        this.setOverrideIndent(false);
        this.encoding = 0;
        this.context = 0;
    }

    protected void closeBlock() {
        switch (this.context) {
            default: {
                break;
            }
            case 1: {
                this.closeTag();
                break;
            }
            case 2: {
                this.closeComment();
                break;
            }
            case 3: {
                this.closeDataBlock();
                break;
            }
            case 4: {
                this.closeProcessingInstruction();
                break;
            }
            case 5: 
            case 6: {
                this.closeDocType();
                break;
            }
            case 7: {
                this.closeMarkupDeclaration();
                break;
            }
            case 8: {
                this.closeRawText();
            }
        }
    }

    protected void closeTag() {
        if (this.context != 1) {
            return;
        }
        if (!this.singleTag) {
            this.printBypass(">");
        } else if (this.hasAttributes) {
            this.printlnBypass("/>");
        } else {
            this.printlnBypass(" />");
        }
        if (!this.singleTag) {
            this.pushIndent();
        }
        this.context = 0;
        this.singleTag = false;
        this.hasAttributes = false;
        this.openTag = null;
    }

    public void popAllTags() {
        this.closeTag();
        while (this.tags.size() > 0) {
            this.popTag();
        }
    }

    public void close() {
        this.popAllTags();
        super.close();
    }

    public void write(int c) {
        this.closeTag();
        this.writeEncoded(c);
    }

    public void println() {
        this.closeTag();
        super.println();
    }

    public void write(char[] buff, int off, int len) {
        this.closeTag();
        switch (this.context) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                this.writeEncoded(buff, off, len);
                return;
            }
        }
        super.write(buff, off, len);
    }

    public void write(String s, int off, int len) {
        this.closeTag();
        switch (this.context) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                this.writeEncoded(s, off, len);
                return;
            }
        }
        super.write(s, off, len);
    }

    protected void printBypass(String s) {
        super.write(s, 0, s.length());
    }

    protected void printlnBypass(String s) {
        super.write(s, 0, s.length());
        super.println();
    }

    protected void writeEncoded(String s, int offset, int len) {
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(offset + i);
            this.writeEncoded(c);
        }
    }

    protected void writeEncoded(char[] buff, int offset, int len) {
        for (int i = 0; i < len; ++i) {
            this.writeEncoded(buff[offset + i]);
        }
    }

    protected void writeInvalidChar(int c) {
        String val = Integer.toHexString(c);
        super.write("\\u", 0, 2);
        int catchUp = 4 - val.length();
        for (int i = 0; i < catchUp; ++i) {
            super.write(48);
        }
        super.write(val, 0, val.length());
    }

    protected void writeEncoded(int c) {
        if (c < 9 || c > 10 && c < 13 || c > 13 && c < 32 || c > 55295 && c < 57344 || c > 65533 && c < 65536 || c > 0x10FFFF) {
            this.writeInvalidChar(c);
        } else if (this.encoding == 1) {
            super.write(c);
        } else if (c == 38) {
            super.write("&amp;", 0, 5);
        } else if (c == 60) {
            super.write("&lt;", 0, 4);
        } else if (c == 62) {
            super.write("&gt;", 0, 4);
        } else if (this.encoding == 2 && c == 34) {
            super.write("&quot;", 0, 6);
        } else if (this.encoding == 2 && c == 9) {
            super.write("&#9;", 0, 4);
        } else if (this.encoding == 3 && c == 39) {
            super.write("&apos;", 0, 6);
        } else {
            super.write(c);
        }
    }

    public static void main(String[] args) throws IOException {
        OutputStreamWriter osw = new OutputStreamWriter(System.out);
        XmlPrintWriter out = new XmlPrintWriter(osw);
        out.printProcessingInstruction("xml");
        out.printAttribute("version", "1.0");
        out.print("encoding='utf-8'");
        out.startDocType("root", "foo.dtd", "test");
        out.startDocType("root", "foo2.dtd", "test2");
        out.startMarkupDeclaration("ENTITY");
        out.print("SYSTEM \"file:data/include-test1.xml\"");
        out.startMarkupDeclaration("ENTITY");
        out.print("SYSTEM \"file:data/include-test2.xml\"");
        out.closeDocType();
        out.startDocType("root", null, null);
        out.startMarkupDeclaration("ENTITY");
        out.print("SYSTEM \"file:data/include-test1.xml\"");
        out.closeDocType();
        out.pushTag("root");
        out.println();
        out.startComment();
        out.println("This is a test of a comment block.");
        out.println("This is the second line of the test.");
        out.println("This line requires encoding the & symbol and the < sign.");
        out.pushTag("firstInner");
        out.printAttribute("test", "A test attribute.");
        out.printAttribute("test2", "An attribute with a double \" in it.");
        out.printAttribute("test3", "An attribute with a single ' in it.");
        out.printTag("single");
        out.printTag("anotherSingle");
        out.printAttribute("foo", "Bar");
        out.printAttribute("bar", "Foo");
        out.pushTag("singleLineExample");
        out.print("Testing.");
        out.popTag();
        out.printProcessingInstruction("test");
        out.println("Some free form processing instructions.");
        out.println("To test things.");
        out.popTag();
        out.println("This is just some body text floating around in the");
        out.println("middle of nowhere.  And it has an & symbol too.");
        out.startDataBlock();
        out.println("This is just some raw data that is not XML at all.");
        out.println("This is how you would include raw data in an XML file.");
        out.println("Even things like < and > are allowed here.");
        out.println("Trying to write some encoded illegal characters [ \u0019\u0018\u000e]");
        out.pushTag("secondInner");
        out.pushTag("nestedInner");
        out.popTag("secondInner");
        out.pushTag("encodedStuff");
        out.println("Trying to write some encoded illegal characters [ \u0019\u0018\u000e]");
        out.popTag();
        out.startComment();
        out.print("We should be in the root tag now.");
        out.closeComment();
        out.printRawText("I can write whatever bad stuff I want here even a '<'.");
        out.startRawText();
        out.println("And here I can even do it without <breaking> a <sweat>...");
        out.println("Since I can do multiple lines & stuff.  Of course, I just made");
        out.println("bad XML.");
        out.closeRawText();
        out.close();
    }
}

