/*
 * Decompiled with CFR 0.152.
 */
package org.progeeks.util.xml;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import org.progeeks.util.log.Log;
import org.progeeks.util.xml.TagReader;
import org.progeeks.util.xml.XmlException;
import org.w3c.dom.Document;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlReader {
    static Log log = Log.getLog(XmlReader.class);
    private LinkedList<Object> objectStack = new LinkedList();
    private LinkedList<CharSequence> textStack = new LinkedList();
    private LinkedList<String> tagStack = new LinkedList();
    private Locator locator;
    private Map<String, TagReader> handlers = new HashMap<String, TagReader>();
    private TagReader defaultHandler = new DefaultTagReader();
    private boolean ignoreTagCase = false;

    public Object readObject(Reader in) throws IOException {
        throw new UnsupportedOperationException("readObjects() not supported.");
    }

    protected void reset() {
        this.objectStack.clear();
        this.tagStack.clear();
        this.textStack.clear();
    }

    protected void setIgnoreTagCase(boolean bool) {
        this.ignoreTagCase = bool;
    }

    protected boolean getIgnoreTagCase() {
        return this.ignoreTagCase;
    }

    protected void setDefaultHandler(TagReader defaultHandler) {
        this.defaultHandler = defaultHandler;
    }

    protected void registerHandler(String tagName, TagReader tagReader) {
        if (this.getIgnoreTagCase()) {
            tagName = tagName.toLowerCase();
        }
        this.handlers.put(tagName, tagReader);
    }

    protected TagReader getTagReader(String tagName) {
        if (this.getIgnoreTagCase()) {
            tagName = tagName.toLowerCase();
        }
        return this.handlers.get(tagName);
    }

    protected Object startTag(String name, Attributes atts) throws SAXException {
        log.debug("startTag(" + name + ")");
        TagReader r = this.getTagReader(name);
        try {
            Object currObj = this.getCurrentObject();
            if (r == null) {
                return this.defaultHandler.tagStart(name, atts, currObj);
            }
            return r.tagStart(name, atts, currObj);
        }
        catch (XmlException e) {
            throw e;
        }
        catch (Exception e) {
            log.error("Error processing tag:" + name, e);
            throw this.createXmlException("Error processing start of tag:" + name, e);
        }
    }

    protected void addTagText(String name, String newText, StringBuffer accumulatedText, Object object) throws SAXException {
        log.debug("addTagText(" + name + ") = [" + newText + "]");
        TagReader r = this.getTagReader(name);
        try {
            Object currObj = this.getCurrentObject();
            if (r == null) {
                r = this.defaultHandler;
            }
            r.tagText(name, newText, accumulatedText, currObj, object);
        }
        catch (XmlException e) {
            throw e;
        }
        catch (Exception e) {
            log.error("Error processing tag:" + name, e);
            throw this.createXmlException("Error processing tag:" + name, e);
        }
    }

    protected void endTag(String name, String text, Object object) throws SAXException {
        log.debug("endTag(" + name + ") = [" + text + "]");
        TagReader r = this.getTagReader(name);
        try {
            Object currObj = this.getCurrentObject();
            if (r == null) {
                this.defaultHandler.tagEnd(name, text, currObj, object);
                return;
            }
            r.tagEnd(name, text, currObj, object);
        }
        catch (XmlException e) {
            throw e;
        }
        catch (Exception e) {
            log.error("Error processing tag:" + name, e);
            throw this.createXmlException("Error processing end of tag:" + name, e);
        }
    }

    protected Locator getDocumentLocator() {
        return this.locator;
    }

    protected Object getCurrentObject() {
        if (this.objectStack.size() > 0) {
            return this.objectStack.getLast();
        }
        return null;
    }

    protected void replaceCurrentObject(Object object) {
        this.objectStack.removeLast();
        this.objectStack.add(object);
    }

    protected Object getPreviousObject() {
        if (this.objectStack.size() > 1) {
            return this.objectStack.get(this.objectStack.size() - 2);
        }
        return null;
    }

    protected int getStackSize() {
        return this.objectStack.size();
    }

    protected Object getRootObject() {
        if (this.objectStack.size() > 0) {
            return this.objectStack.getFirst();
        }
        return null;
    }

    protected String getLocation() {
        if (this.locator != null) {
            if (this.locator.getSystemId() == null) {
                return "[" + this.locator.getLineNumber() + ":" + this.locator.getColumnNumber() + "]";
            }
            return "(" + this.locator.getSystemId() + ")[" + this.locator.getLineNumber() + ":" + this.locator.getColumnNumber() + "]";
        }
        return "[unknown location]";
    }

    protected XmlException createXmlException(String message) {
        return new XmlException(message + "  " + this.getLocation());
    }

    protected XmlException createXmlException(String message, Throwable cause) {
        return new XmlException(message + "  " + this.getLocation(), cause);
    }

    public static Map<String, String> getAttributesAsMap(Attributes atts) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (int i = 0; i < atts.getLength(); ++i) {
            result.put(atts.getQName(i), atts.getValue(i));
        }
        return result;
    }

    protected final void readXml(Reader in) throws IOException, XmlException {
        this.readXml(null, in);
    }

    protected void readXml(String systemId, Reader in) throws IOException, XmlException {
        try {
            SAXParserFactory spf = SAXParserFactory.newInstance();
            SAXParser sp = spf.newSAXParser();
            XMLReader reader = sp.getXMLReader();
            InputSource input = new InputSource(in);
            input.setSystemId(systemId);
            XmlHandler xmlHandler = new XmlHandler();
            reader.setContentHandler(xmlHandler);
            reader.setErrorHandler(xmlHandler);
            reader.setEntityResolver(xmlHandler);
            reader.parse(input);
        }
        catch (IOException e) {
            log.error("Error reading XML", e);
            throw e;
        }
        catch (ParserConfigurationException e) {
            log.error("Error configuring parser", e);
            throw this.createXmlException("Error configuring parser", e);
        }
        catch (SAXParseException e) {
            String location = "";
            if (e.getSystemId() != null) {
                location = location + "(" + e.getSystemId() + ")";
            }
            location = location + "[" + e.getLineNumber() + ":" + e.getColumnNumber() + "]";
            Exception real = e;
            if (e.getException() != null) {
                real = e.getException();
            }
            throw new XmlException("Error reading XML - " + location, real);
        }
        catch (SAXException e) {
            throw new XmlException("Error reading XML - Unknown Location", e);
        }
        finally {
            in.close();
        }
    }

    protected void readXml(Document document) throws XmlException {
        Transformer transformer = null;
        try {
            transformer = TransformerFactory.newInstance().newTransformer();
        }
        catch (TransformerException e) {
            throw new XmlException("Failed to create identity transformer.", e);
        }
        this.readXml(document, transformer);
    }

    protected void readXml(Document document, Transformer transformer) throws XmlException {
        try {
            XmlHandler xmlHandler = new XmlHandler();
            SAXResult result = new SAXResult(xmlHandler);
            transformer.transform(new DOMSource(document), result);
        }
        catch (TransformerException e) {
            throw new XmlException("Tranformation of document during read failed.", e);
        }
    }

    protected InputSource resolveEntity(String publicId, String systemId) throws SAXException {
        if (systemId.startsWith("file:")) {
            String file = systemId.substring("file:".length());
            File f = new File(file);
            try {
                FileInputStream in = new FileInputStream(f.getAbsoluteFile());
                InputSource is = new InputSource(in);
                is.setPublicId(publicId);
                is.setSystemId(systemId);
                return is;
            }
            catch (IOException e) {
                throw new SAXException("Error reading:" + f, e);
            }
        }
        return null;
    }

    protected class XmlHandler
    extends DefaultHandler {
        private StringBuffer currentText = new StringBuffer();
        private String currentTag;

        protected XmlHandler() {
        }

        public void setDocumentLocator(Locator docLocator) {
            XmlReader.this.locator = docLocator;
        }

        public void startElement(String uri, String localName, String qualifiedName, Attributes atts) throws SAXException {
            XmlReader.this.tagStack.add(this.currentTag);
            XmlReader.this.textStack.add(this.currentText);
            this.currentTag = qualifiedName;
            this.currentText = new StringBuffer();
            Object obj = XmlReader.this.startTag(qualifiedName, atts);
            XmlReader.this.objectStack.add(obj);
        }

        public void endElement(String uri, String localName, String qualifiedName) throws SAXException {
            String text = this.currentText.toString();
            this.endElement(qualifiedName, text);
            this.currentText = (StringBuffer)XmlReader.this.textStack.removeLast();
            this.currentTag = (String)XmlReader.this.tagStack.removeLast();
        }

        public void endElement(String name, String text) throws SAXException {
            XmlReader.this.endTag(name, text, XmlReader.this.objectStack.removeLast());
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            String chars = new String(ch, start, length);
            if (log.isDebugEnabled()) {
                log.debug("characters(" + chars + ")");
            }
            XmlReader.this.addTagText(this.currentTag, chars, this.currentText, XmlReader.this.objectStack.getLast());
        }

        public void processingInstruction(String target, String data) throws SAXException {
        }

        public void fatalError(SAXParseException e) throws SAXException {
        }

        public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
            return XmlReader.this.resolveEntity(publicId, systemId);
        }
    }

    private static class DefaultTagReader
    extends TagReader {
        private DefaultTagReader() {
        }

        public Object tagStart(String tag, Attributes atts, Object parent) throws XmlException {
            throw new XmlException("Unknown tag:" + tag);
        }

        public void tagEnd(String tag, String text, Object parent, Object tagObject) throws XmlException {
            throw new XmlException("Unknown tag:" + tag);
        }
    }
}

